/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Utils;

public class UpdateChannelConfiguration {
    private static final Log logger = LogFactory.getLog(UpdateChannelConfiguration.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private byte[] configBytes = null;

    public UpdateChannelConfiguration() {
    }

    public UpdateChannelConfiguration(File configFile) throws IOException, InvalidArgumentException {
        if (configFile == null) {
            throw new InvalidArgumentException("UpdateChannelConfiguration configFile must be non-null");
        }
        logger.trace((Object)String.format("Creating UpdateChannelConfiguration from file %s", configFile.getAbsolutePath()));
        try (FileInputStream is = new FileInputStream(configFile);){
            this.configBytes = IOUtils.toByteArray((InputStream)is);
        }
    }

    public UpdateChannelConfiguration(byte[] configAsBytes) throws InvalidArgumentException {
        if (configAsBytes == null) {
            throw new InvalidArgumentException("UpdateChannelConfiguration configAsBytes must be non-null");
        }
        logger.trace((Object)"Creating UpdateChannelConfiguration from bytes");
        this.configBytes = configAsBytes;
    }

    public void setUpdateChannelConfiguration(byte[] updateChannelConfigurationAsBytes) throws InvalidArgumentException {
        if (updateChannelConfigurationAsBytes == null) {
            throw new InvalidArgumentException("UpdateChannelConfiguration updateChannelConfigurationAsBytes must be non-null");
        }
        logger.trace((Object)"Creating setUpdateChannelConfiguration from bytes");
        this.configBytes = updateChannelConfigurationAsBytes;
    }

    public byte[] getUpdateChannelConfigurationAsBytes() {
        if (this.configBytes == null) {
            logger.error((Object)"UpdateChannelConfiguration configBytes is null!");
        } else if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("getUpdateChannelConfigurationAsBytes: %s", Utils.toHexString(this.configBytes)));
        }
        return this.configBytes;
    }
}

