/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.util.Set;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;

public interface User {
    public String getName();

    public Set<String> getRoles();

    public String getAccount();

    public String getAffiliation();

    public Enrollment getEnrollment();

    public String getMspId();

    public static void userContextCheck(User userContext) {
        if (userContext == null) {
            throw new NullPointerException("UserContext is null");
        }
        String userName = userContext.getName();
        if (Utils.isNullOrEmpty(userName)) {
            throw new IllegalArgumentException("UserContext user's name missing.");
        }
        Enrollment enrollment = userContext.getEnrollment();
        if (enrollment == null) {
            throw new IllegalArgumentException(String.format("UserContext for user %s has no enrollment set.", userName));
        }
        if (enrollment instanceof X509Enrollment) {
            if (Utils.isNullOrEmpty(enrollment.getCert())) {
                throw new IllegalArgumentException(String.format("UserContext for user %s enrollment missing user certificate.", userName));
            }
            if (null == enrollment.getKey()) {
                throw new IllegalArgumentException(String.format("UserContext for user %s has Enrollment missing signing key", userName));
            }
        }
        if (Utils.isNullOrEmpty(userContext.getMspId())) {
            throw new IllegalArgumentException(String.format("UserContext for user %s  has user's MSPID missing.", userName));
        }
    }
}

