/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;

public class Config {
    private static final Log logger = LogFactory.getLog(Config.class);
    private static final String DEFAULT_CONFIG = "config.properties";
    public static final String ORG_HYPERLEDGER_FABRIC_SDK_CONFIGURATION = "org.hyperledger.fabric.sdk.configuration";
    private static final String DEFAULT_NULL = "\u0000DEFAULT_NULL\u0000".intern();
    public static final String PROPOSAL_WAIT_TIME = "org.hyperledger.fabric.sdk.proposal.wait.time";
    public static final String CHANNEL_CONFIG_WAIT_TIME = "org.hyperledger.fabric.sdk.channelconfig.wait_time";
    public static final String TRANSACTION_CLEANUP_UP_TIMEOUT_WAIT_TIME = "org.hyperledger.fabric.sdk.client.transaction_cleanup_up_timeout_wait_time";
    public static final String ORDERER_RETRY_WAIT_TIME = "org.hyperledger.fabric.sdk.orderer_retry.wait_time";
    public static final String ORDERER_WAIT_TIME = "org.hyperledger.fabric.sdk.orderer.ordererWaitTimeMilliSecs";
    public static final String PEER_EVENT_REGISTRATION_WAIT_TIME = "org.hyperledger.fabric.sdk.peer.eventRegistration.wait_time";
    public static final String PEER_EVENT_RETRY_WAIT_TIME = "org.hyperledger.fabric.sdk.peer.retry_wait_time";
    public static final String PEER_EVENT_RECONNECTION_WARNING_RATE = "org.hyperledger.fabric.sdk.peer.reconnection_warning_rate";
    public static final String GENESISBLOCK_WAIT_TIME = "org.hyperledger.fabric.sdk.channel.genesisblock_wait_time";
    public static final String DEFAULT_CRYPTO_SUITE_FACTORY = "org.hyperledger.fabric.sdk.crypto.default_crypto_suite_factory";
    public static final String SECURITY_LEVEL = "org.hyperledger.fabric.sdk.security_level";
    public static final String SECURITY_PROVIDER_CLASS_NAME = "org.hyperledger.fabric.sdk.security_provider_class_name";
    public static final String SECURITY_CURVE_MAPPING = "org.hyperledger.fabric.sdk.security_curve_mapping";
    public static final String HASH_ALGORITHM = "org.hyperledger.fabric.sdk.hash_algorithm";
    public static final String ASYMMETRIC_KEY_TYPE = "org.hyperledger.fabric.sdk.crypto.asymmetric_key_type";
    public static final String CERTIFICATE_FORMAT = "org.hyperledger.fabric.sdk.crypto.certificate_format";
    public static final String SIGNATURE_ALGORITHM = "org.hyperledger.fabric.sdk.crypto.default_signature_algorithm";
    public static final String MAX_LOG_STRING_LENGTH = "org.hyperledger.fabric.sdk.log.stringlengthmax";
    public static final String EXTRALOGLEVEL = "org.hyperledger.fabric.sdk.log.extraloglevel";
    public static final String LOGGERLEVEL = "org.hyperledger.fabric.sdk.loglevel";
    public static final String DIAGNOTISTIC_FILE_DIRECTORY = "org.hyperledger.fabric.sdk.diagnosticFileDir";
    public static final String CONN_SSL_PROVIDER = "org.hyperledger.fabric.sdk.connections.ssl.sslProvider";
    public static final String CONN_SSL_NEGTYPE = "org.hyperledger.fabric.sdk.connections.ssl.negotiationType";
    public static final String CLIENT_THREAD_EXECUTOR_COREPOOLSIZE = "org.hyperledger.fabric.sdk.client.thread_executor_corepoolsize";
    public static final String CLIENT_THREAD_EXECUTOR_MAXIMUMPOOLSIZE = "org.hyperledger.fabric.sdk.client.thread_executor_maximumpoolsize";
    public static final String CLIENT_THREAD_EXECUTOR_KEEPALIVETIME = "org.hyperledger.fabric.sdk.client.thread_executor_keepalivetime";
    public static final String CLIENT_THREAD_EXECUTOR_KEEPALIVETIMEUNIT = "org.hyperledger.fabric.sdk.client.thread_executor_keepalivetimeunit";
    public static final String PROPOSAL_CONSISTENCY_VALIDATION = "org.hyperledger.fabric.sdk.proposal.consistency_validation";
    public static final String SERVICE_DISCOVER_FREQ_SECONDS = "org.hyperledger.fabric.sdk.service_discovery.frequency_sec";
    public static final String SERVICE_DISCOVER_WAIT_TIME = "org.hyperledger.fabric.sdk.service_discovery.discovery_wait_time";
    public static final String SERVICE_DISCOVER_AS_LOCALHOST = "org.hyperledger.fabric.sdk.service_discovery.as_localhost";
    public static final String LIFECYCLE_CHAINCODE_ENDORSEMENT_PLUGIN = "org.hyperledger.fabric.sdk.lifecycle.chaincode_endorsement_plugin";
    public static final String LIFECYCLE_CHAINCODE_VALIDATION_PLUGIN = "org.hyperledger.fabric.sdk.lifecycle.chaincode_validation_plugin";
    public static final String LIFECYCLE_INITREQUIREDDEFAULT = "org.hyperledger.fabric.sdk.lifecycle.initRequiredDefault";
    private static Config config;
    private static final Properties sdkProperties;
    private static final AtomicLong count;
    private Map<Integer, String> curveMapping = null;
    private int extraLogLevel = -1;
    DiagnosticFileDumper diagnosticFileDumper = null;

    public String getNextID() {
        return "" + count.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config() {
        try {
            File loadFile = new File(System.getProperty(ORG_HYPERLEDGER_FABRIC_SDK_CONFIGURATION, DEFAULT_CONFIG)).getAbsoluteFile();
            logger.debug((Object)String.format("Loading configuration from %s and it is present: %b", loadFile.toString(), loadFile.exists()));
            FileInputStream configProps = new FileInputStream(loadFile);
            sdkProperties.load(configProps);
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Failed to load any configuration from: %s. Using toolkit defaults", DEFAULT_CONFIG));
        }
        finally {
            Config.defaultProperty(PROPOSAL_WAIT_TIME, "120000");
            Config.defaultProperty(CHANNEL_CONFIG_WAIT_TIME, "15000");
            Config.defaultProperty(ORDERER_RETRY_WAIT_TIME, "200");
            Config.defaultProperty(ORDERER_WAIT_TIME, "10000");
            Config.defaultProperty(PEER_EVENT_REGISTRATION_WAIT_TIME, "5000");
            Config.defaultProperty(PEER_EVENT_RETRY_WAIT_TIME, "500");
            Config.defaultProperty(GENESISBLOCK_WAIT_TIME, "5000");
            Config.defaultProperty(TRANSACTION_CLEANUP_UP_TIMEOUT_WAIT_TIME, "600000");
            Config.defaultProperty(DEFAULT_CRYPTO_SUITE_FACTORY, "org.hyperledger.fabric.sdk.security.HLSDKJCryptoSuiteFactory");
            Config.defaultProperty(SECURITY_LEVEL, "256");
            Config.defaultProperty(SECURITY_PROVIDER_CLASS_NAME, BouncyCastleProvider.class.getName());
            Config.defaultProperty(SECURITY_CURVE_MAPPING, "256=secp256r1:384=secp384r1");
            Config.defaultProperty(HASH_ALGORITHM, "SHA2");
            Config.defaultProperty(ASYMMETRIC_KEY_TYPE, "EC");
            Config.defaultProperty(CERTIFICATE_FORMAT, "X.509");
            Config.defaultProperty(SIGNATURE_ALGORITHM, "SHA256withECDSA");
            Config.defaultProperty(CONN_SSL_PROVIDER, "openSSL");
            Config.defaultProperty(CONN_SSL_NEGTYPE, "TLS");
            Config.defaultProperty(CLIENT_THREAD_EXECUTOR_COREPOOLSIZE, "0");
            Config.defaultProperty(CLIENT_THREAD_EXECUTOR_MAXIMUMPOOLSIZE, "2147483647");
            Config.defaultProperty(CLIENT_THREAD_EXECUTOR_KEEPALIVETIME, "60");
            Config.defaultProperty(CLIENT_THREAD_EXECUTOR_KEEPALIVETIMEUNIT, "SECONDS");
            Config.defaultProperty(MAX_LOG_STRING_LENGTH, "64");
            Config.defaultProperty(EXTRALOGLEVEL, "0");
            Config.defaultProperty(LOGGERLEVEL, null);
            Config.defaultProperty(DIAGNOTISTIC_FILE_DIRECTORY, null);
            Config.defaultProperty(PROPOSAL_CONSISTENCY_VALIDATION, "true");
            Config.defaultProperty(PEER_EVENT_RECONNECTION_WARNING_RATE, "50");
            Config.defaultProperty(SERVICE_DISCOVER_FREQ_SECONDS, "120");
            Config.defaultProperty(SERVICE_DISCOVER_WAIT_TIME, "5000");
            Config.defaultProperty(SERVICE_DISCOVER_AS_LOCALHOST, "false");
            Config.defaultProperty(LIFECYCLE_CHAINCODE_ENDORSEMENT_PLUGIN, DEFAULT_NULL);
            Config.defaultProperty(LIFECYCLE_CHAINCODE_VALIDATION_PLUGIN, DEFAULT_NULL);
            Config.defaultProperty(LIFECYCLE_INITREQUIREDDEFAULT, DEFAULT_NULL);
            String inLogLevel = sdkProperties.getProperty(LOGGERLEVEL);
            if (null != inLogLevel) {
                Level setTo;
                switch (inLogLevel.toUpperCase()) {
                    case "TRACE": {
                        setTo = Level.TRACE;
                        break;
                    }
                    case "DEBUG": {
                        setTo = Level.DEBUG;
                        break;
                    }
                    case "INFO": {
                        setTo = Level.INFO;
                        break;
                    }
                    case "WARN": {
                        setTo = Level.WARN;
                        break;
                    }
                    case "ERROR": {
                        setTo = Level.ERROR;
                        break;
                    }
                    default: {
                        setTo = Level.INFO;
                    }
                }
                if (null != setTo) {
                    Logger.getLogger((String)"org.hyperledger.fabric").setLevel(setTo);
                }
            }
        }
    }

    public static Config getConfig() {
        if (null == config) {
            config = new Config();
        }
        return config;
    }

    private String getProperty(String property) {
        String ret;
        if (!sdkProperties.containsKey(property)) {
            logger.warn((Object)String.format("No configuration value found for '%s'", property));
        }
        if (DEFAULT_NULL.equals(ret = sdkProperties.getProperty(property))) {
            ret = null;
        }
        return ret;
    }

    private static void defaultProperty(String key, String value) {
        String ret = System.getProperty(key);
        if (ret != null) {
            sdkProperties.put(key, ret);
        } else {
            String envKey = key.toUpperCase().replaceAll("\\.", "_");
            ret = System.getenv(envKey);
            if (null != ret) {
                sdkProperties.put(key, ret);
            } else if (null == sdkProperties.getProperty(key) && value != null) {
                sdkProperties.put(key, value);
            }
        }
    }

    public int getSecurityLevel() {
        return Integer.parseInt(this.getProperty(SECURITY_LEVEL));
    }

    public String getSecurityProviderClassName() {
        return this.getProperty(SECURITY_PROVIDER_CLASS_NAME);
    }

    public String getHashAlgorithm() {
        return this.getProperty(HASH_ALGORITHM);
    }

    public String getDefaultSSLProvider() {
        return this.getProperty(CONN_SSL_PROVIDER);
    }

    public String getDefaultSSLNegotiationType() {
        return this.getProperty(CONN_SSL_NEGTYPE);
    }

    public Map<Integer, String> getSecurityCurveMapping() {
        if (this.curveMapping == null) {
            this.curveMapping = Config.parseSecurityCurveMappings(this.getProperty(SECURITY_CURVE_MAPPING));
        }
        return Collections.unmodifiableMap(this.curveMapping);
    }

    public static Map<Integer, String> parseSecurityCurveMappings(String property) {
        HashMap<Integer, String> lcurveMapping = new HashMap<Integer, String>(8);
        if (property != null && !property.isEmpty()) {
            String[] cmaps;
            for (String mape : cmaps = property.split("[ \t]*:[ \t]*")) {
                String[] ep = mape.split("[ \t]*=[ \t]*");
                if (ep.length != 2) {
                    logger.warn((Object)String.format("Bad curve mapping for %s in property %s", mape, SECURITY_CURVE_MAPPING));
                    continue;
                }
                try {
                    int parseInt = Integer.parseInt(ep[0]);
                    lcurveMapping.put(parseInt, ep[1]);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)String.format("Bad curve mapping. Integer needed for strength %s for %s in property %s", ep[0], mape, SECURITY_CURVE_MAPPING));
                }
            }
        }
        return lcurveMapping;
    }

    public long getProposalWaitTime() {
        return Long.parseLong(this.getProperty(PROPOSAL_WAIT_TIME));
    }

    public long getGenesisBlockWaitTime() {
        return Long.parseLong(this.getProperty(GENESISBLOCK_WAIT_TIME));
    }

    public long getChannelConfigWaitTime() {
        return Long.parseLong(this.getProperty(CHANNEL_CONFIG_WAIT_TIME));
    }

    public long getOrdererRetryWaitTime() {
        return Long.parseLong(this.getProperty(ORDERER_RETRY_WAIT_TIME));
    }

    public long getOrdererWaitTime() {
        return Long.parseLong(this.getProperty(ORDERER_WAIT_TIME));
    }

    public long getPeerEventRegistrationWaitTime() {
        return Long.parseLong(this.getProperty(PEER_EVENT_REGISTRATION_WAIT_TIME));
    }

    public long getPeerRetryWaitTime() {
        return Long.parseLong(this.getProperty(PEER_EVENT_RETRY_WAIT_TIME));
    }

    public long getPeerEventReconnectionWarningRate() {
        return Long.parseLong(this.getProperty(PEER_EVENT_RECONNECTION_WARNING_RATE));
    }

    public int getServiceDiscoveryFreqSeconds() {
        return Integer.parseInt(this.getProperty(SERVICE_DISCOVER_FREQ_SECONDS));
    }

    public int getServiceDiscoveryWaitTime() {
        return Integer.parseInt(this.getProperty(SERVICE_DISCOVER_WAIT_TIME));
    }

    public boolean discoverAsLocalhost() {
        return Boolean.parseBoolean(this.getProperty(SERVICE_DISCOVER_AS_LOCALHOST));
    }

    public String getAsymmetricKeyType() {
        return this.getProperty(ASYMMETRIC_KEY_TYPE);
    }

    public String getCertificateFormat() {
        return this.getProperty(CERTIFICATE_FORMAT);
    }

    public String getSignatureAlgorithm() {
        return this.getProperty(SIGNATURE_ALGORITHM);
    }

    public String getDefaultCryptoSuiteFactory() {
        return this.getProperty(DEFAULT_CRYPTO_SUITE_FACTORY);
    }

    public int maxLogStringLength() {
        return Integer.parseInt(this.getProperty(MAX_LOG_STRING_LENGTH));
    }

    public boolean getProposalConsistencyValidation() {
        return Boolean.parseBoolean(this.getProperty(PROPOSAL_CONSISTENCY_VALIDATION));
    }

    public boolean extraLogLevel(int val) {
        if (this.extraLogLevel == -1) {
            this.extraLogLevel = Integer.parseInt(this.getProperty(EXTRALOGLEVEL));
        }
        return val <= this.extraLogLevel;
    }

    public DiagnosticFileDumper getDiagnosticFileDumper() {
        if (this.diagnosticFileDumper != null) {
            return this.diagnosticFileDumper;
        }
        String dd = sdkProperties.getProperty(DIAGNOTISTIC_FILE_DIRECTORY);
        if (dd != null) {
            this.diagnosticFileDumper = DiagnosticFileDumper.configInstance(new File(dd));
        }
        return this.diagnosticFileDumper;
    }

    public long getTransactionListenerCleanUpTimeout() {
        return Long.parseLong(this.getProperty(TRANSACTION_CLEANUP_UP_TIMEOUT_WAIT_TIME));
    }

    public int getClientThreadExecutorCorePoolSize() {
        return Integer.parseInt(this.getProperty(CLIENT_THREAD_EXECUTOR_COREPOOLSIZE));
    }

    public int getClientThreadExecutorMaxiumPoolSize() {
        return Integer.parseInt(this.getProperty(CLIENT_THREAD_EXECUTOR_MAXIMUMPOOLSIZE));
    }

    public long getClientThreadExecutorKeepAliveTime() {
        return Long.parseLong(this.getProperty(CLIENT_THREAD_EXECUTOR_KEEPALIVETIME));
    }

    public TimeUnit getClientThreadExecutorKeepAliveTimeUnit() {
        return TimeUnit.valueOf(this.getProperty(CLIENT_THREAD_EXECUTOR_KEEPALIVETIMEUNIT));
    }

    public String getDefaultChaincodeEndorsementPlugin() {
        return this.getProperty(LIFECYCLE_CHAINCODE_ENDORSEMENT_PLUGIN);
    }

    public String getDefaultChaincodeValidationPlugin() {
        return this.getProperty(LIFECYCLE_CHAINCODE_VALIDATION_PLUGIN);
    }

    public Boolean getLifecycleInitRequiredDefault() {
        String property = this.getProperty(LIFECYCLE_INITREQUIREDDEFAULT);
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return null;
    }

    static {
        sdkProperties = new Properties();
        count = new AtomicLong(0L);
    }
}

