/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.helper;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class DiagnosticFileDumper
implements Runnable {
    private final File directory;
    private final String dirAbsolutePath;
    private final String pid;
    private static Thread thread;
    private final BlockingQueue<QueEntry> queEntries = new LinkedBlockingQueue<QueEntry>();
    private static DiagnosticFileDumper singleInstance;
    private static final AtomicInteger counter;

    private DiagnosticFileDumper(File directory) {
        this.directory = directory;
        this.dirAbsolutePath = directory == null ? null : directory.getAbsolutePath();
        this.pid = DiagnosticFileDumper.getPID() + "";
    }

    static DiagnosticFileDumper configInstance(File directory) {
        if (singleInstance == null) {
            singleInstance = new DiagnosticFileDumper(directory);
            thread = new Thread(singleInstance);
            thread.setName("DiagnosticFileDumper");
            thread.setDaemon(true);
            thread.start();
        }
        return singleInstance;
    }

    public String createDiagnosticProtobufFile(byte[] byteString) {
        return this.createDiagnosticFile(byteString, "protobuf_", "proto");
    }

    private boolean cantWrite() {
        return null == this.directory || !this.directory.exists() || !this.directory.isDirectory() || !this.directory.canWrite();
    }

    public String createDiagnosticFile(byte[] bytes) {
        return this.createDiagnosticFile(bytes, null, null);
    }

    public String createDiagnosticTarFile(byte[] bytes) {
        return this.createDiagnosticFile(bytes, null, "tgz");
    }

    public String createDiagnosticFile(String msg) {
        return this.createDiagnosticFile(msg.getBytes(StandardCharsets.UTF_8), null, null);
    }

    public String createDiagnosticFile(byte[] bytes, String prefix, String ext) {
        String fileName = "";
        if (this.cantWrite()) {
            return "Missing dump directory or can not write: " + this.dirAbsolutePath;
        }
        if (null != bytes) {
            if (null == prefix) {
                prefix = "diagnostic_";
            }
            if (null == ext) {
                ext = "bin";
            }
            SimpleDateFormat dateFormatGmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss_SSS");
            dateFormatGmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            fileName = prefix + dateFormatGmt.format(new Date()) + "P" + this.pid + "_" + Thread.currentThread().getId() + "_" + counter.addAndGet(1) + "." + ext;
            fileName = fileName.replaceAll("\\:", "-");
            new QueEntry(fileName, bytes);
        }
        return fileName;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    LinkedList<QueEntry> entries = new LinkedList<QueEntry>();
                    entries.add(this.queEntries.take());
                    this.queEntries.drainTo(entries);
                    if (this.cantWrite()) {
                        return;
                    }
                    entries.forEach(queEntry -> {
                        try {
                            final AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get(this.dirAbsolutePath, queEntry.fileName), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                            channel.write(ByteBuffer.wrap(queEntry.dataBytes), 0L, null, new CompletionHandler<Integer, Object>(){

                                @Override
                                public void completed(Integer result, Object attachment) {
                                    try {
                                        channel.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }

                                @Override
                                public void failed(Throwable exc, Object attachment) {
                                    try {
                                        channel.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    static {
        singleInstance = null;
        counter = new AtomicInteger(0);
    }

    class QueEntry {
        final String fileName;
        final byte[] dataBytes;

        QueEntry(String fileName, byte[] dataBytes) {
            this.fileName = fileName;
            this.dataBytes = dataBytes;
            DiagnosticFileDumper.this.queEntries.add(this);
        }
    }
}

