/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.helper;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.hyperledger.fabric.sdk.helper.Config;

public final class Utils {
    private static final Log logger = LogFactory.getLog(Utils.class);
    private static final boolean TRACE_ENABED = logger.isTraceEnabled();
    private static final Config config = Config.getConfig();
    private static final int MAX_LOG_STRING_LENGTH = config.maxLogStringLength();
    private static final Map<Class<?>, Function<String, ?>> STRING_CONVERSIONS_BY_TYPE = new ImmutableMap.Builder().put(Byte.class, Byte::valueOf).put(Byte.TYPE, Byte::valueOf).put(Short.class, Short::valueOf).put(Short.TYPE, Short::valueOf).put(Integer.class, Integer::valueOf).put(Integer.TYPE, Integer::valueOf).put(Long.class, Long::valueOf).put(Long.TYPE, Long::valueOf).put(Float.class, Float::valueOf).put(Float.TYPE, Float::valueOf).put(Double.class, Double::valueOf).put(Double.TYPE, Double::valueOf).put(Boolean.class, Boolean::valueOf).put(Boolean.TYPE, Boolean::valueOf).put(BigInteger.class, BigInteger::new).put(BigDecimal.class, BigDecimal::new).build();
    private static final int NONONCE_LENGTH = 24;
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String generateParameterHash(String path, String func, List<String> args) {
        logger.debug((Object)String.format("GenerateParameterHash : path=%s, func=%s, args=%s", path, func, args));
        StringBuilder param = new StringBuilder(path);
        param.append(func);
        args.forEach(param::append);
        return Hex.toHexString((byte[])Utils.hash(param.toString().getBytes(StandardCharsets.UTF_8), (Digest)new SHA3Digest()));
    }

    public static String generateDirectoryHash(String rootDir, String chaincodeDir, String hash) throws IOException {
        Path projectPath = rootDir == null ? Paths.get(chaincodeDir, new String[0]) : Paths.get(rootDir, chaincodeDir);
        File dir = projectPath.toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException(String.format("The chaincode path \"%s\" is invalid", projectPath));
        }
        StringBuilder hashBuilder = new StringBuilder(hash);
        Files.walk(projectPath, new FileVisitOption[0]).sorted(Comparator.naturalOrder()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(file -> {
            try {
                byte[] buf = Utils.readFile(file);
                byte[] toHash = Arrays.concatenate((byte[])buf, (byte[])hashBuilder.toString().getBytes(StandardCharsets.UTF_8));
                hashBuilder.setLength(0);
                hashBuilder.append(Hex.toHexString((byte[])Utils.hash(toHash, (Digest)new SHA3Digest())));
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("Error while reading file %s", file.getAbsolutePath()), ex);
            }
        });
        if (hashBuilder.toString().equals(hash)) {
            throw new IOException(String.format("The chaincode directory \"%s\" has no files", projectPath));
        }
        return hashBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateTarGz(File sourceDirectory, String pathPrefix, File chaincodeMetaInf) throws IOException {
        ByteArrayOutputStream bos;
        block43: {
            logger.trace((Object)String.format("generateTarGz: sourceDirectory: %s, pathPrefix: %s, chaincodeMetaInf: %s", sourceDirectory == null ? "null" : sourceDirectory.getAbsolutePath(), pathPrefix, chaincodeMetaInf == null ? "null" : chaincodeMetaInf.getAbsolutePath()));
            bos = new ByteArrayOutputStream(500000);
            String sourcePath = sourceDirectory.getAbsolutePath();
            try (TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)bos));){
                Throwable throwable;
                FileInputStream fileInputStream;
                TarArchiveEntry archiveEntry;
                String relativePath;
                archiveOutputStream.setLongFileMode(2);
                Collection childrenFiles = FileUtils.listFiles((File)sourceDirectory, null, (boolean)true);
                for (File childFile : childrenFiles) {
                    String childPath = childFile.getAbsolutePath();
                    relativePath = childPath.substring(sourcePath.length() + 1);
                    if (pathPrefix != null) {
                        relativePath = Utils.combinePaths(pathPrefix, relativePath);
                    }
                    relativePath = FilenameUtils.separatorsToUnix((String)relativePath);
                    if (TRACE_ENABED) {
                        logger.trace((Object)String.format("generateTarGz: Adding '%s' entry from source '%s' to archive.", relativePath, childFile.getAbsolutePath()));
                    }
                    archiveEntry = new TarArchiveEntry(childFile, relativePath);
                    archiveOutputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
                    try {
                        fileInputStream = new FileInputStream(childFile);
                        throwable = null;
                        try {
                            IOUtils.copy((InputStream)fileInputStream, (OutputStream)archiveOutputStream);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fileInputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            fileInputStream.close();
                        }
                    }
                    finally {
                        archiveOutputStream.closeArchiveEntry();
                    }
                }
                if (null == chaincodeMetaInf) break block43;
                childrenFiles = FileUtils.listFiles((File)chaincodeMetaInf, null, (boolean)true);
                URI metabase = chaincodeMetaInf.toURI();
                for (File childFile : childrenFiles) {
                    relativePath = Paths.get("META-INF", metabase.relativize(childFile.toURI()).getPath()).toString();
                    if (TRACE_ENABED) {
                        logger.trace((Object)String.format("generateTarGz: Adding '%s' entry from source '%s' to archive.", relativePath, childFile.getAbsolutePath()));
                    }
                    archiveEntry = new TarArchiveEntry(childFile, relativePath);
                    archiveOutputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
                    try {
                        fileInputStream = new FileInputStream(childFile);
                        throwable = null;
                        try {
                            IOUtils.copy((InputStream)fileInputStream, (OutputStream)archiveOutputStream);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (fileInputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            fileInputStream.close();
                        }
                    }
                    finally {
                        archiveOutputStream.closeArchiveEntry();
                    }
                }
            }
        }
        return bos.toByteArray();
    }

    public static byte[] readFile(File input) throws IOException {
        return Files.readAllBytes(Paths.get(input.getAbsolutePath(), new String[0]));
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static Timestamp generateTimestamp() {
        Instant time = Instant.now();
        return Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build();
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                Path rootPath = Paths.get(file.getAbsolutePath(), new String[0]);
                Files.walk(rootPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            } else {
                file.delete();
            }
        } else {
            throw new RuntimeException("File or directory does not exist");
        }
    }

    public static byte[] hash(byte[] input, Digest digest) {
        byte[] retValue = new byte[digest.getDigestSize()];
        digest.update(input, 0, input.length);
        digest.doFinal(retValue, 0);
        return retValue;
    }

    public static String combinePaths(String first, String ... other) {
        return Paths.get(first, other).toString();
    }

    public static byte[] readFileFromClasspath(String fileName) throws IOException {
        try (InputStream is = Utils.class.getClassLoader().getResourceAsStream(fileName);){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public static Properties parseGrpcUrl(String url) {
        if (Utils.isNullOrEmpty(url)) {
            throw new RuntimeException("URL cannot be null or empty");
        }
        Properties props = new Properties();
        Pattern p = Pattern.compile("([^:]+)[:]//([^:]+)[:]([0-9]+)", 2);
        Matcher m = p.matcher(url);
        if (m.matches()) {
            props.setProperty("protocol", m.group(1));
            props.setProperty("host", m.group(2));
            props.setProperty("port", m.group(3));
            String protocol = props.getProperty("protocol");
            if (!"grpc".equals(protocol) && !"grpcs".equals(protocol)) {
                throw new RuntimeException(String.format("Invalid protocol expected grpc or grpcs and found %s.", protocol));
            }
        } else {
            throw new RuntimeException("URL must be of the format protocol://host:port. Found: '" + url + "'");
        }
        return props;
    }

    public static Exception checkGrpcUrl(String url) {
        try {
            Utils.parseGrpcUrl(url);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    public static boolean isNullOrEmpty(String url) {
        return url == null || url.isEmpty();
    }

    public static String logString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String ret = string.replaceAll("[^\\p{Print}]", "?");
        ret = ret.substring(0, Math.min(ret.length(), MAX_LOG_STRING_LENGTH)) + (ret.length() > MAX_LOG_STRING_LENGTH ? "..." : "");
        return ret;
    }

    public static byte[] generateNonce() {
        byte[] values = new byte[24];
        RANDOM.nextBytes(values);
        return values;
    }

    public static String toHexString(ByteString byteString) {
        if (byteString == null) {
            return null;
        }
        return org.apache.commons.codec.binary.Hex.encodeHexString((byte[])byteString.toByteArray());
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return org.apache.commons.codec.binary.Hex.encodeHexString((byte[])bytes);
    }

    public static String toHexString(String bytes) {
        if (bytes == null) {
            return null;
        }
        return org.apache.commons.codec.binary.Hex.encodeHexString((byte[])bytes.getBytes(StandardCharsets.UTF_8));
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] parameterTypes, Object[] args) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (parameterTypes.length != args.length) {
            throw new IllegalArgumentException("Parameters types " + java.util.Arrays.toString(parameterTypes) + " do not match arguments " + java.util.Arrays.toString(args));
        }
        Method method = Utils.lookupMethod(target.getClass(), methodName, parameterTypes);
        Object[] coercedArgs = new Object[args.length];
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            coercedArgs[i] = Utils.convertArgumentToType(args[i], methodParameterTypes[i]);
        }
        return method.invoke(target, coercedArgs);
    }

    private static Method lookupMethod(Class<?> cls, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return cls.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException originalException) {
            List candidates = java.util.Arrays.stream(cls.getMethods()).filter(it -> it.getName().equals(name)).filter(it -> it.getParameterCount() == parameterTypes.length).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                throw originalException;
            }
            if (candidates.size() == 1) {
                return (Method)candidates.get(0);
            }
            for (int i = 0; i < candidates.size() - 1; ++i) {
                Object[] types2;
                Object[] types1 = ((Method)candidates.get(i)).getParameterTypes();
                if (java.util.Arrays.equals(types1, types2 = ((Method)candidates.get(i + 1)).getParameterTypes())) continue;
                throw originalException;
            }
            return (Method)candidates.get(0);
        }
    }

    private static Object convertArgumentToType(Object arg, Class<?> type) {
        if (arg.getClass().equals(type) || !(arg instanceof String)) {
            return arg;
        }
        Function<String, ?> convert = STRING_CONVERSIONS_BY_TYPE.get(type);
        if (null == convert) {
            throw new IllegalArgumentException("Unable to convert \"" + arg + "\" to " + type.getTypeName());
        }
        return convert.apply((String)arg);
    }

    private Utils() {
    }
}

