/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.protobuf.ByteString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;

public class IdemixCredRequest {
    private final ECP nym;
    private final BIG issuerNonce;
    private final BIG proofC;
    private final BIG proofS;
    private static final String CREDREQUEST_LABEL = "credRequest";

    public IdemixCredRequest(BIG sk, BIG issuerNonce, IdemixIssuerPublicKey ipk) {
        if (sk == null) {
            throw new IllegalArgumentException("Cannot create idemix credrequest from null Secret Key input");
        }
        if (issuerNonce == null) {
            throw new IllegalArgumentException("Cannot create idemix credrequest from null issuer nonce input");
        }
        if (ipk == null) {
            throw new IllegalArgumentException("Cannot create idemix credrequest from null Issuer Public Key input");
        }
        RAND rng = IdemixUtils.getRand();
        this.nym = ipk.getHsk().mul(sk);
        this.issuerNonce = new BIG(issuerNonce);
        BIG rsk = IdemixUtils.randModOrder(rng);
        ECP t = ipk.getHsk().mul(rsk);
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, CREDREQUEST_LABEL.getBytes());
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(ipk.getHsk()));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.nym));
        proofData = IdemixUtils.append(proofData, IdemixUtils.bigToBytes(issuerNonce));
        proofData = IdemixUtils.append(proofData, ipk.getHash());
        this.proofC = IdemixUtils.hashModOrder(proofData);
        this.proofS = BIG.modmul((BIG)this.proofC, (BIG)sk, (BIG)IdemixUtils.GROUP_ORDER).plus(rsk);
        this.proofS.mod(IdemixUtils.GROUP_ORDER);
    }

    IdemixCredRequest(Idemix.CredRequest proto) {
        if (proto == null) {
            throw new IllegalArgumentException("Cannot create idemix credrequest from null input");
        }
        this.nym = IdemixUtils.transformFromProto(proto.getNym());
        this.proofC = BIG.fromBytes((byte[])proto.getProofC().toByteArray());
        this.proofS = BIG.fromBytes((byte[])proto.getProofS().toByteArray());
        this.issuerNonce = BIG.fromBytes((byte[])proto.getIssuerNonce().toByteArray());
    }

    ECP getNym() {
        return this.nym;
    }

    Idemix.CredRequest toProto() {
        return Idemix.CredRequest.newBuilder().setNym(IdemixUtils.transformToProto(this.nym)).setProofC(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofC))).setProofS(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofS))).setIssuerNonce(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.issuerNonce))).build();
    }

    boolean check(IdemixIssuerPublicKey ipk) {
        if (this.nym == null || this.issuerNonce == null || this.proofC == null || this.proofS == null || ipk == null) {
            return false;
        }
        ECP t = ipk.getHsk().mul(this.proofS);
        t.sub(this.nym.mul(this.proofC));
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, CREDREQUEST_LABEL.getBytes());
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(ipk.getHsk()));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.nym));
        proofData = IdemixUtils.append(proofData, IdemixUtils.bigToBytes(this.issuerNonce));
        proofData = IdemixUtils.append(proofData, ipk.getHash());
        byte[] hproofdata = IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(proofData));
        return Arrays.equals(IdemixUtils.bigToBytes(this.proofC), hproofdata);
    }

    public String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(stringWriter));
        jsonWriter.writeObject(this.toJsonObject());
        jsonWriter.close();
        return stringWriter.toString();
    }

    public JsonObject toJsonObject() {
        JsonObjectBuilder factory = Json.createObjectBuilder();
        if (this.nym != null) {
            JsonObjectBuilder factory2 = Json.createObjectBuilder();
            factory2.add("x", Base64.getEncoder().encodeToString(IdemixUtils.bigToBytes(this.nym.getX())));
            factory2.add("y", Base64.getEncoder().encodeToString(IdemixUtils.bigToBytes(this.nym.getY())));
            factory.add("nym", (JsonValue)factory2.build());
        }
        if (this.issuerNonce != null) {
            String b64encoded = Base64.getEncoder().encodeToString(IdemixUtils.bigToBytes(this.issuerNonce));
            factory.add("issuer_nonce", b64encoded);
        }
        if (this.proofC != null) {
            factory.add("proof_c", Base64.getEncoder().encodeToString(IdemixUtils.bigToBytes(this.proofC)));
        }
        if (this.proofS != null) {
            factory.add("proof_s", Base64.getEncoder().encodeToString(IdemixUtils.bigToBytes(this.proofS)));
        }
        return factory.build();
    }
}

