/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.protobuf.ByteString;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.FP256BN.ECP2;
import org.apache.milagro.amcl.FP256BN.FP12;
import org.apache.milagro.amcl.FP256BN.PAIR;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.idemix.IdemixCredRequest;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerKey;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;

public class IdemixCredential {
    private final ECP A;
    private final ECP B;
    private final BIG E;
    private final BIG S;
    private final byte[][] Attrs;

    IdemixCredential(IdemixIssuerKey key, IdemixCredRequest m, BIG[] attrs) {
        if (key == null || key.getIpk() == null || m == null || attrs == null) {
            throw new IllegalArgumentException("Cannot create idemix credential from null input");
        }
        if (attrs.length != key.getIpk().getAttributeNames().length) {
            throw new IllegalArgumentException("Amount of attribute values does not match amount of attributes in issuer public key");
        }
        RAND rng = IdemixUtils.getRand();
        this.E = IdemixUtils.randModOrder(rng);
        this.S = IdemixUtils.randModOrder(rng);
        this.B = new ECP();
        this.B.copy(IdemixUtils.genG1);
        this.B.add(m.getNym());
        this.B.add(key.getIpk().getHRand().mul(this.S));
        for (int i = 0; i < attrs.length / 2; ++i) {
            this.B.add(key.getIpk().getHAttrs()[2 * i].mul2(attrs[2 * i], key.getIpk().getHAttrs()[2 * i + 1], attrs[2 * i + 1]));
        }
        if (attrs.length % 2 != 0) {
            this.B.add(key.getIpk().getHAttrs()[attrs.length - 1].mul(attrs[attrs.length - 1]));
        }
        BIG exp = new BIG(key.getIsk()).plus(this.E);
        exp.mod(IdemixUtils.GROUP_ORDER);
        exp.invmodp(IdemixUtils.GROUP_ORDER);
        this.A = this.B.mul(exp);
        this.Attrs = new byte[attrs.length][32];
        byte[] b = new byte[32];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i].toBytes(b);
            System.arraycopy(b, 0, this.Attrs[i], 0, 32);
        }
    }

    public IdemixCredential(Idemix.Credential proto) {
        if (proto == null) {
            throw new IllegalArgumentException("Cannot create idemix credential from null input");
        }
        this.A = IdemixUtils.transformFromProto(proto.getA());
        this.B = IdemixUtils.transformFromProto(proto.getB());
        this.E = BIG.fromBytes((byte[])proto.getE().toByteArray());
        this.S = BIG.fromBytes((byte[])proto.getS().toByteArray());
        this.Attrs = new byte[proto.getAttrsCount()][];
        for (int i = 0; i < proto.getAttrsCount(); ++i) {
            this.Attrs[i] = proto.getAttrs(i).toByteArray();
        }
    }

    ECP getA() {
        return this.A;
    }

    ECP getB() {
        return this.B;
    }

    BIG getE() {
        return this.E;
    }

    BIG getS() {
        return this.S;
    }

    public byte[][] getAttrs() {
        return this.Attrs;
    }

    public boolean verify(BIG sk, IdemixIssuerPublicKey ipk) {
        if (ipk == null || this.Attrs.length != ipk.getAttributeNames().length) {
            return false;
        }
        for (byte[] attr : this.Attrs) {
            if (attr != null) continue;
            return false;
        }
        ECP bPrime = new ECP();
        bPrime.copy(IdemixUtils.genG1);
        bPrime.add(ipk.getHsk().mul2(sk, ipk.getHRand(), this.S));
        for (int i = 0; i < this.Attrs.length / 2; ++i) {
            bPrime.add(ipk.getHAttrs()[2 * i].mul2(BIG.fromBytes((byte[])this.Attrs[2 * i]), ipk.getHAttrs()[2 * i + 1], BIG.fromBytes((byte[])this.Attrs[2 * i + 1])));
        }
        if (this.Attrs.length % 2 != 0) {
            bPrime.add(ipk.getHAttrs()[this.Attrs.length - 1].mul(BIG.fromBytes((byte[])this.Attrs[this.Attrs.length - 1])));
        }
        if (!this.B.equals(bPrime)) {
            return false;
        }
        ECP2 a = IdemixUtils.genG2.mul(this.E);
        a.add(ipk.getW());
        a.affine();
        return PAIR.fexp((FP12)PAIR.ate((ECP2)a, (ECP)this.A)).equals(PAIR.fexp((FP12)PAIR.ate((ECP2)IdemixUtils.genG2, (ECP)this.B)));
    }

    Idemix.Credential toProto() {
        Idemix.Credential.Builder builder = Idemix.Credential.newBuilder().setA(IdemixUtils.transformToProto(this.A)).setB(IdemixUtils.transformToProto(this.B)).setE(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.E))).setS(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.S)));
        for (byte[] attr : this.Attrs) {
            builder.addAttrs(ByteString.copyFrom((byte[])attr));
        }
        return builder.build();
    }
}

