/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.FP256BN.ECP2;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;

public class IdemixIssuerPublicKey {
    private final String[] AttributeNames;
    private final ECP Hsk;
    private final ECP HRand;
    private final ECP[] HAttrs;
    private final ECP2 W;
    private final ECP BarG1;
    private final ECP BarG2;
    private final BIG ProofC;
    private final BIG ProofS;
    private byte[] Hash = new byte[0];

    IdemixIssuerPublicKey(String[] attributeNames, BIG isk) {
        if (attributeNames == null || isk == null) {
            throw new IllegalArgumentException("Cannot create IdemixIssuerPublicKey from null input");
        }
        HashSet<String> map = new HashSet<String>();
        for (String item : attributeNames) {
            if (map.add(item)) continue;
            throw new IllegalArgumentException("Attribute " + item + " appears multiple times in attributeNames");
        }
        RAND rng = IdemixUtils.getRand();
        this.AttributeNames = attributeNames;
        this.W = IdemixUtils.genG2.mul(isk);
        this.HAttrs = new ECP[attributeNames.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            this.HAttrs[i] = IdemixUtils.genG1.mul(IdemixUtils.randModOrder(rng));
        }
        this.Hsk = IdemixUtils.genG1.mul(IdemixUtils.randModOrder(rng));
        this.HRand = IdemixUtils.genG1.mul(IdemixUtils.randModOrder(rng));
        this.BarG1 = IdemixUtils.genG1.mul(IdemixUtils.randModOrder(rng));
        this.BarG2 = this.BarG1.mul(isk);
        BIG r = IdemixUtils.randModOrder(rng);
        ECP2 t1 = IdemixUtils.genG2.mul(r);
        ECP t2 = this.BarG1.mul(r);
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t1));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t2));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(IdemixUtils.genG2));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.BarG1));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.W));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.BarG2));
        this.ProofC = IdemixUtils.hashModOrder(proofData);
        this.ProofS = BIG.modmul((BIG)this.ProofC, (BIG)isk, (BIG)IdemixUtils.GROUP_ORDER).plus(r);
        this.ProofS.mod(IdemixUtils.GROUP_ORDER);
        byte[] serializedIpk = this.toProto().toByteArray();
        this.Hash = IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(serializedIpk));
    }

    public IdemixIssuerPublicKey(Idemix.IssuerPublicKey proto) {
        int i;
        if (proto == null) {
            throw new IllegalArgumentException("Cannot create IdemixIssuerPublicKey from null input");
        }
        if (proto.getHAttrsCount() < proto.getAttributeNamesCount()) {
            throw new IllegalArgumentException("Serialized IPk does not contain enough HAttr values");
        }
        this.AttributeNames = new String[proto.getAttributeNamesCount()];
        for (i = 0; i < proto.getAttributeNamesCount(); ++i) {
            this.AttributeNames[i] = proto.getAttributeNames(i);
        }
        this.HAttrs = new ECP[proto.getHAttrsCount()];
        for (i = 0; i < proto.getHAttrsCount(); ++i) {
            this.HAttrs[i] = IdemixUtils.transformFromProto(proto.getHAttrs(i));
        }
        this.BarG1 = IdemixUtils.transformFromProto(proto.getBarG1());
        this.BarG2 = IdemixUtils.transformFromProto(proto.getBarG2());
        this.HRand = IdemixUtils.transformFromProto(proto.getHRand());
        this.Hsk = IdemixUtils.transformFromProto(proto.getHSk());
        this.ProofC = BIG.fromBytes((byte[])proto.getProofC().toByteArray());
        this.ProofS = BIG.fromBytes((byte[])proto.getProofS().toByteArray());
        this.W = IdemixUtils.transformFromProto(proto.getW());
        byte[] serializedIpk = this.toProto().toByteArray();
        this.Hash = IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(serializedIpk));
    }

    public boolean check() {
        if (this.AttributeNames == null || this.Hsk == null || this.HRand == null || this.HAttrs == null || this.BarG1 == null || this.BarG1.is_infinity() || this.BarG2 == null || this.HAttrs.length < this.AttributeNames.length) {
            return false;
        }
        for (int i = 0; i < this.AttributeNames.length; ++i) {
            if (this.HAttrs[i] != null) continue;
            return false;
        }
        ECP2 t1 = IdemixUtils.genG2.mul(this.ProofS);
        ECP t2 = this.BarG1.mul(this.ProofS);
        t1.add(this.W.mul(BIG.modneg((BIG)this.ProofC, (BIG)IdemixUtils.GROUP_ORDER)));
        t2.add(this.BarG2.mul(BIG.modneg((BIG)this.ProofC, (BIG)IdemixUtils.GROUP_ORDER)));
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t1));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t2));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(IdemixUtils.genG2));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.BarG1));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.W));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.BarG2));
        return Arrays.equals(IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(proofData)), IdemixUtils.bigToBytes(this.ProofC));
    }

    Idemix.IssuerPublicKey toProto() {
        Idemix.ECP[] ipkHAttrs = new Idemix.ECP[this.HAttrs.length];
        for (int i = 0; i < this.HAttrs.length; ++i) {
            ipkHAttrs[i] = IdemixUtils.transformToProto(this.HAttrs[i]);
        }
        return Idemix.IssuerPublicKey.newBuilder().setProofC(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.ProofC))).setProofS(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.ProofS))).setW(IdemixUtils.transformToProto(this.W)).setHSk(IdemixUtils.transformToProto(this.Hsk)).setHRand(IdemixUtils.transformToProto(this.HRand)).addAllAttributeNames(Arrays.asList(this.AttributeNames)).setHash(ByteString.copyFrom((byte[])this.Hash)).setBarG1(IdemixUtils.transformToProto(this.BarG1)).setBarG2(IdemixUtils.transformToProto(this.BarG2)).addAllHAttrs(Arrays.asList(ipkHAttrs)).build();
    }

    public String[] getAttributeNames() {
        return this.AttributeNames;
    }

    protected ECP getHsk() {
        return this.Hsk;
    }

    protected ECP getHRand() {
        return this.HRand;
    }

    protected ECP[] getHAttrs() {
        return this.HAttrs;
    }

    protected ECP2 getW() {
        return this.W;
    }

    public byte[] getHash() {
        return this.Hash;
    }
}

