/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;

public class IdemixPseudonym {
    private final ECP Nym;
    private final BIG RandNym;

    public IdemixPseudonym(BIG sk, IdemixIssuerPublicKey ipk) {
        if (sk == null || ipk == null) {
            throw new IllegalArgumentException("Cannot construct idemix pseudonym from null input");
        }
        RAND rng = IdemixUtils.getRand();
        this.RandNym = IdemixUtils.randModOrder(rng);
        this.Nym = ipk.getHsk().mul2(sk, ipk.getHRand(), this.RandNym);
    }

    public ECP getNym() {
        return this.Nym;
    }

    BIG getRandNym() {
        return this.RandNym;
    }
}

