/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixPseudonym;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;

public class IdemixPseudonymSignature {
    private final BIG proofC;
    private final BIG proofSSk;
    private final BIG nonce;
    private final BIG proofSRNym;
    private static final String NYM_SIGN_LABEL = "sign";

    public IdemixPseudonymSignature(BIG sk, IdemixPseudonym pseudonym, IdemixIssuerPublicKey ipk, byte[] msg) {
        if (sk == null || pseudonym == null || pseudonym.getNym() == null || pseudonym.getRandNym() == null || ipk == null || msg == null) {
            throw new IllegalArgumentException("Cannot create IdemixPseudonymSignature from null input");
        }
        RAND rng = IdemixUtils.getRand();
        this.nonce = IdemixUtils.randModOrder(rng);
        BIG rsk = IdemixUtils.randModOrder(rng);
        BIG rRNym = IdemixUtils.randModOrder(rng);
        ECP t = ipk.getHsk().mul2(rsk, ipk.getHRand(), rRNym);
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, NYM_SIGN_LABEL.getBytes());
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(pseudonym.getNym()));
        proofData = IdemixUtils.append(proofData, ipk.getHash());
        proofData = IdemixUtils.append(proofData, msg);
        BIG cvalue = IdemixUtils.hashModOrder(proofData);
        byte[] finalProofData = new byte[]{};
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(cvalue));
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(this.nonce));
        this.proofC = IdemixUtils.hashModOrder(finalProofData);
        this.proofSSk = new BIG(rsk);
        this.proofSSk.add(BIG.modmul((BIG)this.proofC, (BIG)sk, (BIG)IdemixUtils.GROUP_ORDER));
        this.proofSSk.mod(IdemixUtils.GROUP_ORDER);
        this.proofSRNym = new BIG(rRNym);
        this.proofSRNym.add(BIG.modmul((BIG)this.proofC, (BIG)pseudonym.getRandNym(), (BIG)IdemixUtils.GROUP_ORDER));
        this.proofSRNym.mod(IdemixUtils.GROUP_ORDER);
    }

    public IdemixPseudonymSignature(Idemix.NymSignature proto) {
        if (proto == null) {
            throw new IllegalArgumentException("Cannot create idemix nym signature from null input");
        }
        this.proofC = BIG.fromBytes((byte[])proto.getProofC().toByteArray());
        this.proofSSk = BIG.fromBytes((byte[])proto.getProofSSk().toByteArray());
        this.proofSRNym = BIG.fromBytes((byte[])proto.getProofSRNym().toByteArray());
        this.nonce = BIG.fromBytes((byte[])proto.getNonce().toByteArray());
    }

    public boolean verify(ECP nym, IdemixIssuerPublicKey ipk, byte[] msg) {
        if (nym == null || ipk == null || msg == null) {
            return false;
        }
        ECP t = ipk.getHsk().mul2(this.proofSSk, ipk.getHRand(), this.proofSRNym);
        t.sub(nym.mul(this.proofC));
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, NYM_SIGN_LABEL.getBytes());
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(nym));
        proofData = IdemixUtils.append(proofData, ipk.getHash());
        proofData = IdemixUtils.append(proofData, msg);
        BIG cvalue = IdemixUtils.hashModOrder(proofData);
        byte[] finalProofData = new byte[]{};
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(cvalue));
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(this.nonce));
        byte[] hashedProofData = IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(finalProofData));
        return Arrays.equals(IdemixUtils.bigToBytes(this.proofC), hashedProofData);
    }

    public Idemix.NymSignature toProto() {
        return Idemix.NymSignature.newBuilder().setProofC(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofC))).setProofSSk(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSSk))).setProofSRNym(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSRNym))).setNonce(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.nonce))).build();
    }
}

