/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.FP256BN.ECP2;
import org.apache.milagro.amcl.FP256BN.FP12;
import org.apache.milagro.amcl.FP256BN.PAIR;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.idemix.IdemixCredential;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixPseudonym;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;
import org.hyperledger.fabric.sdk.idemix.NonRevocationProver;
import org.hyperledger.fabric.sdk.idemix.NonRevocationVerifier;
import org.hyperledger.fabric.sdk.idemix.RevocationAlgorithm;
import org.hyperledger.fabric.sdk.idemix.RevocationAuthority;

public class IdemixSignature {
    private final ECP aPrime;
    private final ECP aBar;
    private final ECP bPrime;
    private final BIG proofC;
    private final BIG proofSSk;
    private final BIG proofSE;
    private final BIG proofSR2;
    private final BIG proofSR3;
    private final BIG proofSSPrime;
    private final BIG[] proofSAttrs;
    private final BIG nonce;
    private final ECP nym;
    private final BIG proofSRNym;
    private Idemix.ECP2 revocationPk;
    private byte[] revocationPKSig;
    private long epoch;
    private Idemix.NonRevocationProof nonRevocationProof;
    private static final String SIGN_LABEL = "sign";

    public IdemixSignature(IdemixCredential c, BIG sk, IdemixPseudonym pseudonym, IdemixIssuerPublicKey ipk, boolean[] disclosure, byte[] msg, int rhIndex, Idemix.CredentialRevocationInformation cri) {
        byte[] nonRevokedProofHashData;
        if (c == null || sk == null || pseudonym == null || pseudonym.getNym() == null || pseudonym.getRandNym() == null || ipk == null || disclosure == null || msg == null || cri == null) {
            throw new IllegalArgumentException("Cannot construct idemix signature from null input");
        }
        if (disclosure.length != c.getAttrs().length) {
            throw new IllegalArgumentException("Disclosure length must be the same as the number of attributes");
        }
        if (cri.getRevocationAlg() >= RevocationAlgorithm.values().length) {
            throw new IllegalArgumentException("CRI specifies unknown revocation algorithm");
        }
        if (cri.getRevocationAlg() != RevocationAlgorithm.ALG_NO_REVOCATION.ordinal() && disclosure[rhIndex]) {
            throw new IllegalArgumentException("Attribute " + rhIndex + " is disclosed but also used a revocation handle attribute, which should remain hidden");
        }
        RevocationAlgorithm revocationAlgorithm = RevocationAlgorithm.values()[cri.getRevocationAlg()];
        int[] hiddenIndices = this.hiddenIndices(disclosure);
        RAND rng = IdemixUtils.getRand();
        BIG r1 = IdemixUtils.randModOrder(rng);
        BIG r2 = IdemixUtils.randModOrder(rng);
        BIG r3 = new BIG(r1);
        r3.invmodp(IdemixUtils.GROUP_ORDER);
        this.nonce = IdemixUtils.randModOrder(rng);
        this.aPrime = PAIR.G1mul((ECP)c.getA(), (BIG)r1);
        this.aBar = PAIR.G1mul((ECP)c.getB(), (BIG)r1);
        this.aBar.sub(PAIR.G1mul((ECP)this.aPrime, (BIG)c.getE()));
        this.bPrime = PAIR.G1mul((ECP)c.getB(), (BIG)r1);
        this.bPrime.sub(PAIR.G1mul((ECP)ipk.getHRand(), (BIG)r2));
        BIG sPrime = new BIG(c.getS());
        sPrime.add(BIG.modneg((BIG)BIG.modmul((BIG)r2, (BIG)r3, (BIG)IdemixUtils.GROUP_ORDER), (BIG)IdemixUtils.GROUP_ORDER));
        sPrime.mod(IdemixUtils.GROUP_ORDER);
        BIG rsk = IdemixUtils.randModOrder(rng);
        BIG re = IdemixUtils.randModOrder(rng);
        BIG rR2 = IdemixUtils.randModOrder(rng);
        BIG rR3 = IdemixUtils.randModOrder(rng);
        BIG rSPrime = IdemixUtils.randModOrder(rng);
        BIG rRNym = IdemixUtils.randModOrder(rng);
        BIG[] rAttrs = new BIG[hiddenIndices.length];
        for (int i = 0; i < hiddenIndices.length; ++i) {
            rAttrs[i] = IdemixUtils.randModOrder(rng);
        }
        NonRevocationProver prover = NonRevocationProver.getNonRevocationProver(revocationAlgorithm);
        int hiddenRHIndex = Ints.indexOf((int[])hiddenIndices, (int)rhIndex);
        if (hiddenRHIndex < 0) {
            hiddenRHIndex = hiddenIndices.length;
        }
        if ((nonRevokedProofHashData = prover.getFSContribution(BIG.fromBytes((byte[])c.getAttrs()[rhIndex]), rAttrs[hiddenRHIndex], cri)) == null) {
            throw new RuntimeException("Failed to compute non-revoked proof");
        }
        ECP t1 = this.aPrime.mul2(re, ipk.getHRand(), rR2);
        ECP t2 = PAIR.G1mul((ECP)ipk.getHRand(), (BIG)rSPrime);
        t2.add(this.bPrime.mul2(rR3, ipk.getHsk(), rsk));
        for (int i = 0; i < hiddenIndices.length / 2; ++i) {
            t2.add(ipk.getHAttrs()[hiddenIndices[2 * i]].mul2(rAttrs[2 * i], ipk.getHAttrs()[hiddenIndices[2 * i + 1]], rAttrs[2 * i + 1]));
        }
        if (hiddenIndices.length % 2 != 0) {
            t2.add(PAIR.G1mul((ECP)ipk.getHAttrs()[hiddenIndices[hiddenIndices.length - 1]], (BIG)rAttrs[hiddenIndices.length - 1]));
        }
        ECP t3 = ipk.getHsk().mul2(rsk, ipk.getHRand(), rRNym);
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, SIGN_LABEL.getBytes());
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t1));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t2));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t3));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.aPrime));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.aBar));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.bPrime));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(pseudonym.getNym()));
        proofData = IdemixUtils.append(proofData, ipk.getHash());
        proofData = IdemixUtils.append(proofData, disclosure);
        proofData = IdemixUtils.append(proofData, msg);
        BIG cvalue = IdemixUtils.hashModOrder(proofData);
        byte[] finalProofData = new byte[]{};
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(cvalue));
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(this.nonce));
        this.proofC = IdemixUtils.hashModOrder(finalProofData);
        this.proofSSk = IdemixUtils.modAdd(rsk, BIG.modmul((BIG)this.proofC, (BIG)sk, (BIG)IdemixUtils.GROUP_ORDER), IdemixUtils.GROUP_ORDER);
        this.proofSE = IdemixUtils.modSub(re, BIG.modmul((BIG)this.proofC, (BIG)c.getE(), (BIG)IdemixUtils.GROUP_ORDER), IdemixUtils.GROUP_ORDER);
        this.proofSR2 = IdemixUtils.modAdd(rR2, BIG.modmul((BIG)this.proofC, (BIG)r2, (BIG)IdemixUtils.GROUP_ORDER), IdemixUtils.GROUP_ORDER);
        this.proofSR3 = IdemixUtils.modSub(rR3, BIG.modmul((BIG)this.proofC, (BIG)r3, (BIG)IdemixUtils.GROUP_ORDER), IdemixUtils.GROUP_ORDER);
        this.proofSSPrime = IdemixUtils.modAdd(rSPrime, BIG.modmul((BIG)this.proofC, (BIG)sPrime, (BIG)IdemixUtils.GROUP_ORDER), IdemixUtils.GROUP_ORDER);
        this.proofSRNym = IdemixUtils.modAdd(rRNym, BIG.modmul((BIG)this.proofC, (BIG)pseudonym.getRandNym(), (BIG)IdemixUtils.GROUP_ORDER), IdemixUtils.GROUP_ORDER);
        this.nym = new ECP();
        this.nym.copy(pseudonym.getNym());
        this.proofSAttrs = new BIG[hiddenIndices.length];
        for (int i = 0; i < hiddenIndices.length; ++i) {
            this.proofSAttrs[i] = new BIG(rAttrs[i]);
            this.proofSAttrs[i].add(BIG.modmul((BIG)this.proofC, (BIG)BIG.fromBytes((byte[])c.getAttrs()[hiddenIndices[i]]), (BIG)IdemixUtils.GROUP_ORDER));
            this.proofSAttrs[i].mod(IdemixUtils.GROUP_ORDER);
        }
        this.revocationPk = cri.getEpochPk();
        this.revocationPKSig = cri.getEpochPkSig().toByteArray();
        this.epoch = cri.getEpoch();
        this.nonRevocationProof = prover.getNonRevocationProof(this.proofC);
    }

    public IdemixSignature(Idemix.Signature proto) {
        if (proto == null) {
            throw new IllegalArgumentException("Cannot construct idemix signature from null input");
        }
        this.aBar = IdemixUtils.transformFromProto(proto.getABar());
        this.aPrime = IdemixUtils.transformFromProto(proto.getAPrime());
        this.bPrime = IdemixUtils.transformFromProto(proto.getBPrime());
        this.nym = IdemixUtils.transformFromProto(proto.getNym());
        this.proofC = BIG.fromBytes((byte[])proto.getProofC().toByteArray());
        this.proofSSk = BIG.fromBytes((byte[])proto.getProofSSk().toByteArray());
        this.proofSE = BIG.fromBytes((byte[])proto.getProofSE().toByteArray());
        this.proofSR2 = BIG.fromBytes((byte[])proto.getProofSR2().toByteArray());
        this.proofSR3 = BIG.fromBytes((byte[])proto.getProofSR3().toByteArray());
        this.proofSSPrime = BIG.fromBytes((byte[])proto.getProofSSPrime().toByteArray());
        this.proofSRNym = BIG.fromBytes((byte[])proto.getProofSRNym().toByteArray());
        this.nonce = BIG.fromBytes((byte[])proto.getNonce().toByteArray());
        this.proofSAttrs = new BIG[proto.getProofSAttrsCount()];
        for (int i = 0; i < proto.getProofSAttrsCount(); ++i) {
            this.proofSAttrs[i] = BIG.fromBytes((byte[])proto.getProofSAttrs(i).toByteArray());
        }
        this.revocationPk = proto.getRevocationEpochPk();
        this.revocationPKSig = proto.getRevocationPkSig().toByteArray();
        this.epoch = proto.getEpoch();
        this.nonRevocationProof = proto.getNonRevocationProof();
    }

    public boolean verify(boolean[] disclosure, IdemixIssuerPublicKey ipk, byte[] msg, BIG[] attributeValues, int rhIndex, PublicKey revPk, int epoch) throws CryptoException {
        int i;
        if (disclosure == null || ipk == null || msg == null || attributeValues == null || attributeValues.length != ipk.getAttributeNames().length || disclosure.length != ipk.getAttributeNames().length) {
            return false;
        }
        for (int i2 = 0; i2 < ipk.getAttributeNames().length; ++i2) {
            if (!disclosure[i2] || attributeValues[i2] != null) continue;
            return false;
        }
        int[] hiddenIndices = this.hiddenIndices(disclosure);
        if (this.proofSAttrs.length != hiddenIndices.length) {
            return false;
        }
        if (this.aPrime.is_infinity()) {
            return false;
        }
        if (this.nonRevocationProof.getRevocationAlg() >= RevocationAlgorithm.values().length) {
            throw new IllegalArgumentException("CRI specifies unknown revocation algorithm");
        }
        RevocationAlgorithm revocationAlgorithm = RevocationAlgorithm.values()[this.nonRevocationProof.getRevocationAlg()];
        if (disclosure[rhIndex]) {
            throw new IllegalArgumentException("Attribute " + rhIndex + " is disclosed but also used a revocation handle attribute, which should remain hidden");
        }
        if (!RevocationAuthority.verifyEpochPK(revPk, this.revocationPk, this.revocationPKSig, epoch, revocationAlgorithm)) {
            return false;
        }
        FP12 temp1 = PAIR.ate((ECP2)ipk.getW(), (ECP)this.aPrime);
        FP12 temp2 = PAIR.ate((ECP2)IdemixUtils.genG2, (ECP)this.aBar);
        temp2.inverse();
        temp1.mul(temp2);
        if (!PAIR.fexp((FP12)temp1).isunity()) {
            return false;
        }
        ECP t1 = this.aPrime.mul2(this.proofSE, ipk.getHRand(), this.proofSR2);
        ECP temp = new ECP();
        temp.copy(this.aBar);
        temp.sub(this.bPrime);
        t1.sub(PAIR.G1mul((ECP)temp, (BIG)this.proofC));
        ECP t2 = PAIR.G1mul((ECP)ipk.getHRand(), (BIG)this.proofSSPrime);
        t2.add(this.bPrime.mul2(this.proofSR3, ipk.getHsk(), this.proofSSk));
        for (i = 0; i < hiddenIndices.length / 2; ++i) {
            t2.add(ipk.getHAttrs()[hiddenIndices[2 * i]].mul2(this.proofSAttrs[2 * i], ipk.getHAttrs()[hiddenIndices[2 * i + 1]], this.proofSAttrs[2 * i + 1]));
        }
        if (hiddenIndices.length % 2 != 0) {
            t2.add(PAIR.G1mul((ECP)ipk.getHAttrs()[hiddenIndices[hiddenIndices.length - 1]], (BIG)this.proofSAttrs[hiddenIndices.length - 1]));
        }
        temp = new ECP();
        temp.copy(IdemixUtils.genG1);
        for (i = 0; i < disclosure.length; ++i) {
            if (!disclosure[i]) continue;
            temp.add(PAIR.G1mul((ECP)ipk.getHAttrs()[i], (BIG)attributeValues[i]));
        }
        t2.add(PAIR.G1mul((ECP)temp, (BIG)this.proofC));
        ECP t3 = ipk.getHsk().mul2(this.proofSSk, ipk.getHRand(), this.proofSRNym);
        t3.sub(this.nym.mul(this.proofC));
        NonRevocationVerifier nonRevokedVerifier = NonRevocationVerifier.getNonRevocationVerifier(revocationAlgorithm);
        int hiddenRHIndex = Ints.indexOf((int[])hiddenIndices, (int)rhIndex);
        if (hiddenRHIndex < 0) {
            hiddenRHIndex = hiddenIndices.length;
        }
        BIG proofSRh = this.proofSAttrs[hiddenRHIndex];
        byte[] nonRevokedProofBytes = nonRevokedVerifier.recomputeFSContribution(this.nonRevocationProof, this.proofC, IdemixUtils.transformFromProto(this.revocationPk), proofSRh);
        if (nonRevokedProofBytes == null) {
            return false;
        }
        byte[] proofData = new byte[]{};
        proofData = IdemixUtils.append(proofData, SIGN_LABEL.getBytes());
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t1));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t2));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(t3));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.aPrime));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.aBar));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.bPrime));
        proofData = IdemixUtils.append(proofData, IdemixUtils.ecpToBytes(this.nym));
        proofData = IdemixUtils.append(proofData, ipk.getHash());
        proofData = IdemixUtils.append(proofData, disclosure);
        proofData = IdemixUtils.append(proofData, msg);
        BIG cvalue = IdemixUtils.hashModOrder(proofData);
        byte[] finalProofData = new byte[]{};
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(cvalue));
        finalProofData = IdemixUtils.append(finalProofData, IdemixUtils.bigToBytes(this.nonce));
        byte[] hashedProofData = IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(finalProofData));
        return Arrays.equals(IdemixUtils.bigToBytes(this.proofC), hashedProofData);
    }

    public Idemix.Signature toProto() {
        Idemix.Signature.Builder builder = Idemix.Signature.newBuilder().setAPrime(IdemixUtils.transformToProto(this.aPrime)).setABar(IdemixUtils.transformToProto(this.aBar)).setBPrime(IdemixUtils.transformToProto(this.bPrime)).setNym(IdemixUtils.transformToProto(this.nym)).setProofC(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofC))).setProofSSk(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSSk))).setProofSE(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSE))).setProofSR2(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSR2))).setProofSR3(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSR3))).setProofSRNym(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSRNym))).setProofSSPrime(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.proofSSPrime))).setNonce(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.nonce))).setRevocationEpochPk(this.revocationPk).setRevocationPkSig(ByteString.copyFrom((byte[])this.revocationPKSig)).setEpoch(this.epoch).setNonRevocationProof(this.nonRevocationProof);
        for (BIG attr : this.proofSAttrs) {
            builder.addProofSAttrs(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(attr)));
        }
        return builder.build();
    }

    private int[] hiddenIndices(boolean[] disclosure) {
        if (disclosure == null) {
            throw new IllegalArgumentException("cannot compute hidden indices of null disclosure");
        }
        ArrayList<Integer> hiddenIndicesList = new ArrayList<Integer>();
        for (int i = 0; i < disclosure.length; ++i) {
            if (disclosure[i]) continue;
            hiddenIndicesList.add(i);
        }
        int[] hiddenIndices = new int[hiddenIndicesList.size()];
        for (int i = 0; i < hiddenIndicesList.size(); ++i) {
            hiddenIndices[i] = (Integer)hiddenIndicesList.get(i);
        }
        return hiddenIndices;
    }
}

