/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.FP256BN.ECP2;
import org.apache.milagro.amcl.FP256BN.FP12;
import org.apache.milagro.amcl.FP256BN.FP2;
import org.apache.milagro.amcl.FP256BN.PAIR;
import org.apache.milagro.amcl.FP256BN.ROM;
import org.apache.milagro.amcl.HASH256;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.protos.idemix.Idemix;

public final class IdemixUtils {
    private static final BIG gx = new BIG(ROM.CURVE_Gx);
    private static final BIG gy = new BIG(ROM.CURVE_Gy);
    static final ECP genG1 = new ECP(gx, gy);
    private static final BIG pxa = new BIG(ROM.CURVE_Pxa);
    private static final BIG pxb = new BIG(ROM.CURVE_Pxb);
    private static final FP2 px = new FP2(pxa, pxb);
    private static final BIG pya = new BIG(ROM.CURVE_Pya);
    private static final BIG pyb = new BIG(ROM.CURVE_Pyb);
    private static final FP2 py = new FP2(pya, pyb);
    static final ECP2 genG2 = new ECP2(px, py);
    static final FP12 genGT = PAIR.fexp((FP12)PAIR.ate((ECP2)genG2, (ECP)genG1));
    static final BIG GROUP_ORDER = new BIG(ROM.CURVE_Order);
    static final int FIELD_BYTES = 32;

    private IdemixUtils() {
    }

    public static RAND getRand() {
        int seedLength = 32;
        SecureRandom random = new SecureRandom();
        byte[] seed = random.generateSeed(seedLength);
        RAND rng = new RAND();
        rng.clean();
        rng.seed(seedLength, seed);
        return rng;
    }

    public static BIG randModOrder(RAND rng) {
        BIG q = new BIG(ROM.CURVE_Order);
        return BIG.randomnum((BIG)q, (RAND)rng);
    }

    public static BIG hashModOrder(byte[] data) {
        HASH256 hash = new HASH256();
        for (byte b : data) {
            hash.process((int)b);
        }
        byte[] hasheddata = hash.hash();
        BIG ret = BIG.fromBytes((byte[])hasheddata);
        ret.mod(GROUP_ORDER);
        return ret;
    }

    public static byte[] bigToBytes(BIG big) {
        byte[] ret = new byte[32];
        big.toBytes(ret);
        return ret;
    }

    static byte[] ecpToBytes(ECP e) {
        byte[] ret = new byte[65];
        e.toBytes(ret, false);
        return ret;
    }

    static byte[] ecpToBytes(ECP2 e) {
        byte[] ret = new byte[128];
        e.toBytes(ret);
        return ret;
    }

    static byte[] append(byte[] data, byte[] toAppend) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            stream.write(data);
            stream.write(toAppend);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stream.toByteArray();
    }

    static byte[] append(byte[] data, boolean[] toAppend) {
        byte[] toAppendBytes = new byte[toAppend.length];
        for (int i = 0; i < toAppend.length; ++i) {
            toAppendBytes[i] = toAppend[i] ? (byte)1 : 0;
        }
        return IdemixUtils.append(data, toAppendBytes);
    }

    static ECP transformFromProto(Idemix.ECP w) {
        byte[] valuex = w.getX().toByteArray();
        byte[] valuey = w.getY().toByteArray();
        return new ECP(BIG.fromBytes((byte[])valuex), BIG.fromBytes((byte[])valuey));
    }

    static ECP2 transformFromProto(Idemix.ECP2 w) {
        byte[] valuexa = w.getXa().toByteArray();
        byte[] valuexb = w.getXb().toByteArray();
        byte[] valueya = w.getYa().toByteArray();
        byte[] valueyb = w.getYb().toByteArray();
        FP2 valuex = new FP2(BIG.fromBytes((byte[])valuexa), BIG.fromBytes((byte[])valuexb));
        FP2 valuey = new FP2(BIG.fromBytes((byte[])valueya), BIG.fromBytes((byte[])valueyb));
        return new ECP2(valuex, valuey);
    }

    static Idemix.ECP2 transformToProto(ECP2 w) {
        byte[] valueXA = new byte[32];
        byte[] valueXB = new byte[32];
        byte[] valueYA = new byte[32];
        byte[] valueYB = new byte[32];
        w.getX().getA().toBytes(valueXA);
        w.getX().getB().toBytes(valueXB);
        w.getY().getA().toBytes(valueYA);
        w.getY().getB().toBytes(valueYB);
        return Idemix.ECP2.newBuilder().setXa(ByteString.copyFrom((byte[])valueXA)).setXb(ByteString.copyFrom((byte[])valueXB)).setYa(ByteString.copyFrom((byte[])valueYA)).setYb(ByteString.copyFrom((byte[])valueYB)).build();
    }

    static Idemix.ECP transformToProto(ECP w) {
        byte[] valueX = new byte[32];
        byte[] valueY = new byte[32];
        w.getX().toBytes(valueX);
        w.getY().toBytes(valueY);
        return Idemix.ECP.newBuilder().setX(ByteString.copyFrom((byte[])valueX)).setY(ByteString.copyFrom((byte[])valueY)).build();
    }

    static BIG modAdd(BIG a, BIG b, BIG m) {
        BIG c = a.plus(b);
        c.mod(m);
        return c;
    }

    static BIG modSub(BIG a, BIG b, BIG m) {
        return IdemixUtils.modAdd(a, BIG.modneg((BIG)b, (BIG)m), m);
    }
}

