/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import org.apache.milagro.amcl.FP256BN.BIG;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.idemix.NopNonRevocationProver;
import org.hyperledger.fabric.sdk.idemix.RevocationAlgorithm;

interface NonRevocationProver {
    public static NonRevocationProver getNonRevocationProver(RevocationAlgorithm algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Revocation algorithm cannot be null");
        }
        switch (algorithm) {
            case ALG_NO_REVOCATION: {
                return new NopNonRevocationProver();
            }
        }
        throw new IllegalArgumentException("Revocation algorithm " + algorithm.name() + " not supported");
    }

    public byte[] getFSContribution(BIG var1, BIG var2, Idemix.CredentialRevocationInformation var3);

    public Idemix.NonRevocationProof getNonRevocationProof(BIG var1);
}

