/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import com.google.protobuf.ByteString;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;
import org.hyperledger.fabric.sdk.idemix.RevocationAlgorithm;
import org.hyperledger.fabric.sdk.idemix.WeakBB;

public class RevocationAuthority {
    private RevocationAuthority() {
    }

    public static int getProofBytes(RevocationAlgorithm alg) {
        if (alg == null) {
            throw new IllegalArgumentException("Revocation algorithm cannot be null");
        }
        switch (alg) {
            case ALG_NO_REVOCATION: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported RevocationAlgorithm: " + alg.name());
    }

    public static KeyPair generateLongTermRevocationKey() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            SecureRandom random = new SecureRandom();
            ECGenParameterSpec params = new ECGenParameterSpec("secp384r1");
            keyGen.initialize(params, random);
            return keyGen.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error during the LTRevocation key. Invalid algorithm");
        }
    }

    public static Idemix.CredentialRevocationInformation createCRI(PrivateKey key, BIG[] unrevokedHandles, int epoch, RevocationAlgorithm alg) throws CryptoException {
        Idemix.CredentialRevocationInformation.Builder builder = Idemix.CredentialRevocationInformation.newBuilder();
        builder.setRevocationAlg(alg.ordinal());
        builder.setEpoch(epoch);
        WeakBB.KeyPair keyPair = WeakBB.weakBBKeyGen();
        if (alg == RevocationAlgorithm.ALG_NO_REVOCATION) {
            builder.setEpochPk(IdemixUtils.transformToProto(IdemixUtils.genG2));
        } else {
            builder.setEpochPk(IdemixUtils.transformToProto(keyPair.getPk()));
        }
        try {
            Idemix.CredentialRevocationInformation cri = builder.build();
            Signature ecdsa = Signature.getInstance("SHA256withECDSA");
            ecdsa.initSign(key);
            ecdsa.update(cri.toByteArray());
            byte[] signed = ecdsa.sign();
            builder.setEpochPkSig(ByteString.copyFrom((byte[])signed));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new CryptoException("Error processing the signature");
        }
        if (alg == RevocationAlgorithm.ALG_NO_REVOCATION) {
            return builder.build();
        }
        throw new IllegalArgumentException("Algorithm " + alg.name() + " not supported");
    }

    public static boolean verifyEpochPK(PublicKey pk, Idemix.ECP2 epochPK, byte[] epochPkSig, long epoch, RevocationAlgorithm alg) throws CryptoException {
        Idemix.CredentialRevocationInformation.Builder builder = Idemix.CredentialRevocationInformation.newBuilder();
        builder.setRevocationAlg(alg.ordinal());
        builder.setEpochPk(epochPK);
        builder.setEpoch(epoch);
        Idemix.CredentialRevocationInformation cri = builder.build();
        byte[] bytesTosign = cri.toByteArray();
        try {
            Signature dsa = Signature.getInstance("SHA256withECDSA");
            dsa.initVerify(pk);
            dsa.update(bytesTosign);
            return dsa.verify(epochPkSig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new CryptoException("Error during the EpochPK verification", e);
        }
    }
}

