/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.idemix;

import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.apache.milagro.amcl.FP256BN.ECP2;
import org.apache.milagro.amcl.FP256BN.FP12;
import org.apache.milagro.amcl.FP256BN.PAIR;
import org.apache.milagro.amcl.RAND;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;

public class WeakBB {
    private WeakBB() {
    }

    public static KeyPair weakBBKeyGen() {
        return new KeyPair();
    }

    public static ECP weakBBSign(BIG sk, BIG m) {
        BIG exp = IdemixUtils.modAdd(sk, m, IdemixUtils.GROUP_ORDER);
        exp.invmodp(IdemixUtils.GROUP_ORDER);
        return IdemixUtils.genG1.mul(exp);
    }

    public static boolean weakBBVerify(ECP2 pk, ECP sig, BIG m) {
        ECP2 p = new ECP2();
        p.copy(pk);
        p.add(IdemixUtils.genG2.mul(m));
        p.affine();
        return PAIR.fexp((FP12)PAIR.ate((ECP2)p, (ECP)sig)).equals(IdemixUtils.genGT);
    }

    public static final class KeyPair {
        private final BIG sk;
        private final ECP2 pk;

        private KeyPair() {
            RAND rng = IdemixUtils.getRand();
            this.sk = IdemixUtils.randModOrder(rng);
            this.pk = IdemixUtils.genG2.mul(this.sk);
        }

        public BIG getSk() {
            return this.sk;
        }

        public ECP2 getPk() {
            return this.pk;
        }
    }
}

