/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.identity;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.FP256BN.ECP;
import org.hyperledger.fabric.protos.common.MspPrincipal;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixSignature;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;
import org.hyperledger.fabric.sdk.identity.IdemixRoles;
import org.hyperledger.fabric.sdk.identity.Identity;

public class IdemixIdentity
implements Identity {
    private static final Log logger = LogFactory.getLog(IdemixIdentity.class);
    private final String mspId;
    private final byte[] ipkHash;
    private final ECP pseudonym;
    private final String ou;
    private final int roleMask;
    private final IdemixSignature associationProof;

    public IdemixIdentity(Identities.SerializedIdentity proto) throws CryptoException, InvalidArgumentException {
        if (proto == null) {
            throw new InvalidArgumentException("Input must not be null");
        }
        this.mspId = proto.getMspid();
        try {
            logger.trace((Object)"Fetching Idemix Proto");
            Identities.SerializedIdemixIdentity idemixProto = Identities.SerializedIdemixIdentity.parseFrom(proto.getIdBytes());
            if (idemixProto == null) {
                throw new IllegalArgumentException("The identity does not contain a serialized idemix identity");
            }
            logger.trace((Object)"Deserializing Nym and attribute values");
            this.pseudonym = new ECP(BIG.fromBytes((byte[])idemixProto.getNymX().toByteArray()), BIG.fromBytes((byte[])idemixProto.getNymY().toByteArray()));
            MspPrincipal.OrganizationUnit ou = MspPrincipal.OrganizationUnit.parseFrom(idemixProto.getOu());
            MspPrincipal.MSPRole role = MspPrincipal.MSPRole.parseFrom(idemixProto.getRole());
            this.ou = ou.getOrganizationalUnitIdentifier();
            this.roleMask = IdemixRoles.getRoleMask(role);
            this.ipkHash = ou.getCertifiersIdentifier().toByteArray();
            logger.trace((Object)"Deserializing Proof");
            this.associationProof = new IdemixSignature(Idemix.Signature.parseFrom(idemixProto.getProof().toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new CryptoException("Cannot deserialize MSP ID", (Exception)((Object)e));
        }
    }

    public IdemixIdentity(String mspId, IdemixIssuerPublicKey ipk, ECP nym, String ou, int roleMask, IdemixSignature proof) throws InvalidArgumentException {
        if (mspId == null) {
            throw new InvalidArgumentException("MSP ID must not be null");
        }
        if (mspId.isEmpty()) {
            throw new InvalidArgumentException("MSP ID must not be empty");
        }
        if (ipk == null) {
            throw new InvalidArgumentException("Issuer Public Key must not be empty");
        }
        if (nym == null) {
            throw new InvalidArgumentException("Identity Mixer Pseudonym (nym) must not be null");
        }
        if (ou == null) {
            throw new InvalidArgumentException("OU attribute must not be null");
        }
        if (ou.isEmpty()) {
            throw new InvalidArgumentException("OU attribute must not be empty");
        }
        if (proof == null) {
            throw new InvalidArgumentException("Proof must not be null");
        }
        this.mspId = mspId;
        this.ipkHash = ipk.getHash();
        this.pseudonym = nym;
        this.ou = ou;
        this.roleMask = roleMask;
        this.associationProof = proof;
    }

    @Override
    public Identities.SerializedIdentity createSerializedIdentity() {
        MspPrincipal.OrganizationUnit ou = MspPrincipal.OrganizationUnit.newBuilder().setCertifiersIdentifier(ByteString.copyFrom((byte[])this.ipkHash)).setMspIdentifier(this.mspId).setOrganizationalUnitIdentifier(this.ou).build();
        MspPrincipal.MSPRole role = MspPrincipal.MSPRole.newBuilder().setRole(IdemixRoles.getMSPRoleFromIdemixRole(this.roleMask)).setMspIdentifier(this.mspId).build();
        Identities.SerializedIdemixIdentity serializedIdemixIdentity = Identities.SerializedIdemixIdentity.newBuilder().setProof(ByteString.copyFrom((byte[])this.associationProof.toProto().toByteArray())).setOu(ByteString.copyFrom((byte[])ou.toByteArray())).setRole(ByteString.copyFrom((byte[])role.toByteArray())).setNymY(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.pseudonym.getY()))).setNymX(ByteString.copyFrom((byte[])IdemixUtils.bigToBytes(this.pseudonym.getX()))).build();
        return Identities.SerializedIdentity.newBuilder().setIdBytes(ByteString.copyFrom((byte[])serializedIdemixIdentity.toByteArray())).setMspid(this.mspId).build();
    }

    public String getOuValue() {
        return this.ou;
    }

    public int getRoleMask() {
        return this.roleMask;
    }

    public String toString() {
        return "IdemixIdentity [ MSP ID: " + this.mspId + " Issuer Public Key Hash: " + Arrays.toString(this.ipkHash) + " Pseudonym: " + this.pseudonym.toRawString() + " OU: " + this.ou + " Role mask: " + this.roleMask + " Association Proof: " + this.associationProof.toProto().toString() + " ]";
    }
}

