/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.identity;

import org.hyperledger.fabric.protos.common.MspPrincipal;

public enum IdemixRoles {
    MEMBER(1),
    ADMIN(2),
    CLIENT(4),
    PEER(8);

    private int value;

    private IdemixRoles(int value) {
        this.value = value;
    }

    int getValue() {
        return this.value;
    }

    static int getRoleMask(IdemixRoles[] roles) {
        int mask = 0;
        for (IdemixRoles role : roles) {
            mask |= role.value;
        }
        return mask;
    }

    static int getRoleMask(MspPrincipal.MSPRole[] roles) {
        int mask = 0;
        for (MspPrincipal.MSPRole role : roles) {
            mask |= IdemixRoles.getIdemixRoleFromMSPRole(role);
        }
        return mask;
    }

    static int getRoleMask(MspPrincipal.MSPRole role) {
        return IdemixRoles.getRoleMask(new MspPrincipal.MSPRole[]{role});
    }

    static boolean checkRole(int bitmask, IdemixRoles searchRole) {
        return (bitmask & searchRole.value) == searchRole.value;
    }

    static int getIdemixRoleFromMSPRole(MspPrincipal.MSPRole role) {
        return IdemixRoles.getIdemixRoleFromMSPRole(role.getRole());
    }

    static int getIdemixRoleFromMSPRole(MspPrincipal.MSPRole.MSPRoleType type) {
        return IdemixRoles.getIdemixRoleFromMSPRole(type.getNumber());
    }

    static int getIdemixRoleFromMSPRole(int type) {
        switch (type) {
            case 1: {
                return ADMIN.getValue();
            }
            case 0: {
                return MEMBER.getValue();
            }
            case 3: {
                return PEER.getValue();
            }
            case 2: {
                return CLIENT.getValue();
            }
        }
        throw new IllegalArgumentException("The provided role is not valid: " + type);
    }

    static MspPrincipal.MSPRole.MSPRoleType getMSPRoleFromIdemixRole(int role) {
        if (role == ADMIN.getValue()) {
            return MspPrincipal.MSPRole.MSPRoleType.ADMIN;
        }
        if (role == MEMBER.getValue()) {
            return MspPrincipal.MSPRole.MSPRoleType.MEMBER;
        }
        if (role == CLIENT.getValue()) {
            return MspPrincipal.MSPRole.MSPRoleType.CLIENT;
        }
        if (role == PEER.getValue()) {
            return MspPrincipal.MSPRole.MSPRoleType.PEER;
        }
        throw new IllegalArgumentException("The provided role value is not valid: " + role);
    }
}

