/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.identity;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.idemix.IdemixCredential;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixPseudonym;
import org.hyperledger.fabric.sdk.idemix.IdemixPseudonymSignature;
import org.hyperledger.fabric.sdk.idemix.IdemixSignature;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;
import org.hyperledger.fabric.sdk.identity.IdemixEnrollment;
import org.hyperledger.fabric.sdk.identity.IdemixIdentity;
import org.hyperledger.fabric.sdk.identity.SigningIdentity;

public class IdemixSigningIdentity
implements SigningIdentity {
    private final IdemixIdentity idemixIdentity;
    private final IdemixIssuerPublicKey ipk;
    private final BIG sk;
    private final IdemixPseudonym pseudonym;
    private final Idemix.CredentialRevocationInformation cri;
    private final IdemixSignature proof;
    private static final boolean[] disclosedFlags = new boolean[]{true, true, false, false};
    private static final byte[] msgEmpty = new byte[0];
    private static final int rhIndex = 3;
    private static final Log logger = LogFactory.getLog(IdemixSigningIdentity.class);

    public IdemixSigningIdentity(IdemixEnrollment enrollment) throws CryptoException, InvalidArgumentException {
        this(enrollment.ipk, enrollment.revocationPk, enrollment.mspId, enrollment.sk, enrollment.cred, enrollment.cri, enrollment.ou, enrollment.roleMask);
    }

    public IdemixSigningIdentity(IdemixIssuerPublicKey ipk, PublicKey revocationPk, String mspId, BIG sk, IdemixCredential cred, Idemix.CredentialRevocationInformation cri, String ou, int role) throws CryptoException, InvalidArgumentException {
        if (ipk == null) {
            throw new InvalidArgumentException("Issuer Public Key (IPK) must not be null");
        }
        if (revocationPk == null) {
            throw new InvalidArgumentException("Revocation PK must not be null");
        }
        if (mspId == null) {
            throw new InvalidArgumentException("MSP ID must not be null");
        }
        if (mspId.isEmpty()) {
            throw new InvalidArgumentException("MSP ID must not be empty");
        }
        if (ou == null) {
            throw new InvalidArgumentException("OU must not be null");
        }
        if (ou.isEmpty()) {
            throw new InvalidArgumentException("OU must not be empty");
        }
        if (sk == null) {
            throw new InvalidArgumentException("SK must not be null");
        }
        if (cred == null) {
            throw new InvalidArgumentException("Credential must not be null");
        }
        if (cri == null) {
            throw new InvalidArgumentException("Credential revocation information must not be null");
        }
        logger.trace((Object)("Verifying public key with hash: " + Arrays.toString(ipk.getHash()) + " \nAttributes: " + Arrays.toString(ipk.getAttributeNames())));
        if (!ipk.check()) {
            CryptoException e = new CryptoException("Issuer public key is not valid");
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        this.ipk = ipk;
        this.sk = sk;
        this.cri = cri;
        logger.trace((Object)"Verifying the credential");
        if (!cred.verify(sk, ipk)) {
            CryptoException e = new CryptoException("Credential is not cryptographically valid");
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        logger.trace((Object)"Checking attributes");
        if (cred.getAttrs().length != 4) {
            throw new CryptoException("Error: There are " + cred.getAttrs().length + " attributes and the expected are 4");
        }
        byte[] ouBytes = cred.getAttrs()[0];
        byte[] roleBytes = cred.getAttrs()[1];
        byte[] eIdBytes = cred.getAttrs()[2];
        byte[] rHBytes = cred.getAttrs()[3];
        BIG[] attributes = new BIG[]{BIG.fromBytes((byte[])ouBytes), BIG.fromBytes((byte[])roleBytes), BIG.fromBytes((byte[])eIdBytes), BIG.fromBytes((byte[])rHBytes)};
        if (!Arrays.equals(IdemixUtils.bigToBytes(IdemixUtils.hashModOrder(ou.getBytes(StandardCharsets.UTF_8))), ouBytes)) {
            throw new IllegalArgumentException("the OU string does not match the credential");
        }
        if (!Arrays.equals(IdemixUtils.bigToBytes(new BIG(role)), roleBytes)) {
            throw new IllegalArgumentException("the role does not match the credential");
        }
        logger.trace((Object)"Generating fresh pseudonym and proof");
        this.pseudonym = new IdemixPseudonym(this.sk, this.ipk);
        this.proof = new IdemixSignature(cred, this.sk, this.pseudonym, this.ipk, disclosedFlags, msgEmpty, 3, cri);
        logger.trace((Object)"Verifying the proof");
        if (!this.proof.verify(disclosedFlags, this.ipk, msgEmpty, attributes, 3, revocationPk, (int)cri.getEpoch())) {
            throw new CryptoException("Generated proof of identity is not valid");
        }
        logger.trace((Object)"Generating the Identity Object");
        this.idemixIdentity = new IdemixIdentity(mspId, this.ipk, this.pseudonym.getNym(), ou, role, this.proof);
        logger.trace((Object)this.idemixIdentity.toString());
    }

    @Override
    public byte[] sign(byte[] msg) throws CryptoException, InvalidArgumentException {
        if (msg == null) {
            throw new InvalidArgumentException("Input must not be null");
        }
        return new IdemixPseudonymSignature(this.sk, this.pseudonym, this.ipk, msg).toProto().toByteArray();
    }

    @Override
    public Identities.SerializedIdentity createSerializedIdentity() {
        return this.idemixIdentity.createSerializedIdentity();
    }

    @Override
    public boolean verifySignature(byte[] msg, byte[] sig) throws CryptoException, InvalidArgumentException {
        if (msg == null) {
            throw new InvalidArgumentException("Message must not be null");
        }
        if (sig == null) {
            throw new InvalidArgumentException("Signature must not be null");
        }
        Idemix.NymSignature nymSigProto = null;
        try {
            nymSigProto = Idemix.NymSignature.parseFrom(sig);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error((Object)("Idemix Nym Signature parsing error, dumping \nSignature: " + Arrays.toString(sig) + " \nMessage: " + Arrays.toString(msg)));
            throw new CryptoException("Could not parse Idemix Nym Signature", (Exception)((Object)e));
        }
        IdemixPseudonymSignature nymSig = new IdemixPseudonymSignature(nymSigProto);
        if (!nymSig.verify(this.pseudonym.getNym(), this.ipk, msg)) {
            logger.error((Object)("Idemix Nym Signature verification error, dumping \nSignature: " + Arrays.toString(sig) + " \nMessage: " + Arrays.toString(msg)));
            return false;
        }
        return true;
    }

    public IdemixPseudonym getNym() {
        return this.pseudonym;
    }

    public IdemixSignature getProof() {
        return this.proof;
    }
}

