/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.security;

import java.lang.reflect.InvocationTargetException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Properties;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.security.CryptoSuiteFactory;

public interface CryptoSuite {
    public CryptoSuiteFactory getCryptoSuiteFactory();

    public Properties getProperties();

    public void loadCACertificates(Collection<Certificate> var1) throws CryptoException;

    public void loadCACertificatesAsBytes(Collection<byte[]> var1) throws CryptoException;

    public KeyPair keyGen() throws CryptoException;

    public byte[] sign(PrivateKey var1, byte[] var2) throws CryptoException;

    public boolean verify(byte[] var1, String var2, byte[] var3, byte[] var4) throws CryptoException;

    public byte[] hash(byte[] var1);

    public String generateCertificationRequest(String var1, KeyPair var2) throws InvalidArgumentException;

    public Certificate bytesToCertificate(byte[] var1) throws CryptoException;

    public static class Factory {
        private Factory() {
        }

        public static CryptoSuite getCryptoSuite() throws IllegalAccessException, InstantiationException, ClassNotFoundException, CryptoException, InvalidArgumentException, NoSuchMethodException, InvocationTargetException {
            return CryptoSuiteFactory.getDefault().getCryptoSuite();
        }

        public static CryptoSuite getCryptoSuite(Properties properties) throws IllegalAccessException, InstantiationException, ClassNotFoundException, CryptoException, InvalidArgumentException, NoSuchMethodException, InvocationTargetException {
            return CryptoSuiteFactory.getDefault().getCryptoSuite(properties);
        }
    }
}

