/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.security.CryptoPrimitives;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.security.CryptoSuiteFactory;

public class HLSDKJCryptoSuiteFactory
implements CryptoSuiteFactory {
    private static final Config config = Config.getConfig();
    private static final int SECURITY_LEVEL = config.getSecurityLevel();
    private static final String HASH_ALGORITHM = config.getHashAlgorithm();
    private static final Map<Properties, CryptoSuite> cache = new ConcurrentHashMap<Properties, CryptoSuite>();
    private static final HLSDKJCryptoSuiteFactory INSTANCE = new HLSDKJCryptoSuiteFactory();
    private static CryptoSuiteFactory theFACTORY = null;

    private HLSDKJCryptoSuiteFactory() {
    }

    @Override
    public CryptoSuite getCryptoSuite(Properties properties) throws CryptoException, InvalidArgumentException {
        CryptoSuite ret = cache.get(properties);
        if (ret == null) {
            try {
                CryptoPrimitives cp = new CryptoPrimitives();
                cp.setProperties(properties);
                cp.init();
                ret = cp;
            }
            catch (Exception e) {
                throw new CryptoException(e.getMessage(), e);
            }
            cache.put(properties, ret);
        }
        return ret;
    }

    @Override
    public CryptoSuite getCryptoSuite() throws CryptoException, InvalidArgumentException {
        Properties properties = new Properties();
        properties.put("org.hyperledger.fabric.sdk.security_level", (Object)SECURITY_LEVEL);
        properties.put("org.hyperledger.fabric.sdk.hash_algorithm", HASH_ALGORITHM);
        return this.getCryptoSuite(properties);
    }

    static synchronized HLSDKJCryptoSuiteFactory instance() {
        return INSTANCE;
    }

    static final synchronized CryptoSuiteFactory getDefault() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (null == theFACTORY) {
            String cf = config.getDefaultCryptoSuiteFactory();
            if (null == cf || cf.isEmpty() || cf.equals(HLSDKJCryptoSuiteFactory.class.getName())) {
                theFACTORY = HLSDKJCryptoSuiteFactory.instance();
            } else {
                Class<?> aClass = Class.forName(cf);
                Method method = aClass.getMethod("instance", new Class[0]);
                Object theFACTORYObject = method.invoke(null, new Object[0]);
                if (null == theFACTORYObject) {
                    throw new InstantiationException(String.format("Class specified by %s has instance method returning null.  Expected object implementing CryptoSuiteFactory interface.", cf));
                }
                if (!(theFACTORYObject instanceof CryptoSuiteFactory)) {
                    throw new InstantiationException(String.format("Class specified by %s has instance method returning a class %s which does not implement interface CryptoSuiteFactory ", cf, theFACTORYObject.getClass().getName()));
                }
                theFACTORY = (CryptoSuiteFactory)theFACTORYObject;
            }
        }
        return theFACTORY;
    }
}

