/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.security.certgen;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.hyperledger.fabric.sdk.security.certgen.TLSCertificateKeyPair;

public class TLSCertificateBuilder {
    private static final SecureRandom rand = new SecureRandom();
    private static final String defaultSignatureAlgorithm = "SHA256withECDSA";
    private static final String defaultKeyType = "EC";
    private String commonName = UUID.randomUUID().toString();
    private String signatureAlgorithm = "SHA256withECDSA";
    private String keyType = "EC";

    public TLSCertificateKeyPair clientCert() {
        try {
            return this.createCert(CertType.CLIENT, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TLSCertificateKeyPair serverCert(String subjectAlternativeName) {
        try {
            return this.createCert(CertType.SERVER, subjectAlternativeName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TLSCertificateKeyPair createCert(CertType certType, String subjectAlternativeName) throws Exception {
        KeyPair keyPair = this.createKeyPair();
        X509Certificate cert = this.createSelfSignedCertificate(certType, keyPair, subjectAlternativeName);
        return TLSCertificateKeyPair.fromX509CertKeyPair(cert, keyPair);
    }

    private X509Certificate createSelfSignedCertificate(CertType certType, KeyPair keyPair, String san) throws Exception {
        X509v3CertificateBuilder certBuilder = this.createCertBuilder(keyPair);
        BasicConstraints constraints = new BasicConstraints(false);
        certBuilder.addExtension(Extension.basicConstraints, true, constraints.getEncoded());
        KeyUsage usage = new KeyUsage(160);
        certBuilder.addExtension(Extension.keyUsage, false, usage.getEncoded());
        certBuilder.addExtension(Extension.extendedKeyUsage, false, certType.keyUsage().getEncoded());
        if (san != null) {
            this.addSAN(certBuilder, san);
        }
        ContentSigner signer = new JcaContentSignerBuilder(this.signatureAlgorithm).build(keyPair.getPrivate());
        X509CertificateHolder holder = certBuilder.build(signer);
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        converter.setProvider((Provider)new BouncyCastleProvider());
        return converter.getCertificate(holder);
    }

    private void addSAN(X509v3CertificateBuilder certBuilder, String san) throws CertIOException {
        ASN1Encodable[] subjectAlternativeNames = new ASN1Encodable[]{new GeneralName(2, san)};
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence(subjectAlternativeNames));
    }

    private X509v3CertificateBuilder createCertBuilder(KeyPair keyPair) {
        X500Name subject = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.commonName).build();
        GregorianCalendar notBefore = new GregorianCalendar();
        ((Calendar)notBefore).add(5, -1);
        GregorianCalendar notAfter = new GregorianCalendar();
        ((Calendar)notAfter).add(1, 10);
        return new JcaX509v3CertificateBuilder(subject, new BigInteger(160, rand), notBefore.getTime(), notAfter.getTime(), subject, keyPair.getPublic());
    }

    private KeyPair createKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keypairGen = KeyPairGenerator.getInstance(this.keyType, (Provider)new BouncyCastleProvider());
        keypairGen.initialize(256, rand);
        return keypairGen.generateKeyPair();
    }

    private static class SelfSignedKeyIdentifier {
        private static SecureRandom rand = new SecureRandom();
        private byte[] bytes = new byte[20];

        SelfSignedKeyIdentifier() {
            rand.nextBytes(this.bytes);
        }

        byte[] authorityKeyIdentifier() {
            return this.bytes;
        }

        byte[] subjectKeyIdentifier() {
            return this.bytes;
        }
    }

    private static enum CertType {
        CLIENT,
        SERVER;


        ExtendedKeyUsage keyUsage() {
            KeyPurposeId[] kpid = new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth};
            if (this.ordinal() == 1) {
                kpid[0] = KeyPurposeId.id_kp_serverAuth;
            }
            return new ExtendedKeyUsage(kpid);
        }
    }
}

