/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.security.certgen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;

public class TLSCertificateKeyPair {
    private byte[] certPemBytes;
    private byte[] certDerBytes;
    private byte[] keyPemBytes;

    private TLSCertificateKeyPair(byte[] certPemBytes, byte[] certDerBytes, byte[] keyPemBytes) {
        this.certPemBytes = certPemBytes;
        this.certDerBytes = certDerBytes;
        this.keyPemBytes = keyPemBytes;
    }

    static TLSCertificateKeyPair fromX509CertKeyPair(X509Certificate x509Cert, KeyPair keyPair) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(baos);
        JcaPEMWriter w = new JcaPEMWriter((Writer)writer);
        w.writeObject((Object)x509Cert);
        w.flush();
        w.close();
        byte[] pemBytes = baos.toByteArray();
        InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(pemBytes));
        PemReader pr = new PemReader((Reader)isr);
        PemObject pem = pr.readPemObject();
        byte[] derBytes = pem.getContent();
        baos = new ByteArrayOutputStream();
        writer = new OutputStreamWriter(baos);
        w = new JcaPEMWriter((Writer)writer);
        JcaPKCS8Generator keygen = new JcaPKCS8Generator(keyPair.getPrivate(), null);
        w.writeObject((PemObjectGenerator)keygen.generate());
        w.flush();
        w.close();
        byte[] keyBytes = baos.toByteArray();
        return new TLSCertificateKeyPair(pemBytes, derBytes, keyBytes);
    }

    public byte[] getCertPEMBytes() {
        return this.certPemBytes;
    }

    public byte[] getCertDERBytes() {
        return this.certDerBytes;
    }

    public byte[] getKeyPemBytes() {
        return this.keyPemBytes;
    }
}

