/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.transaction.LSCCProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;

public class InstallProposalBuilder
extends LSCCProposalBuilder {
    private static final Log logger = LogFactory.getLog(InstallProposalBuilder.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final Config config = Config.getConfig();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private String chaincodePath;
    private File chaincodeSource;
    private String chaincodeName;
    private String chaincodeVersion;
    private TransactionRequest.Type chaincodeLanguage;
    protected String action = "install";
    private InputStream chaincodeInputStream;
    private File chaincodeMetaInfLocation;

    protected InstallProposalBuilder() {
    }

    public static InstallProposalBuilder newBuilder() {
        return new InstallProposalBuilder();
    }

    public InstallProposalBuilder chaincodePath(String chaincodePath) {
        this.chaincodePath = chaincodePath;
        return this;
    }

    public InstallProposalBuilder chaincodeName(String chaincodeName) {
        this.chaincodeName = chaincodeName;
        return this;
    }

    public InstallProposalBuilder setChaincodeSource(File chaincodeSource) {
        this.chaincodeSource = chaincodeSource;
        return this;
    }

    public InstallProposalBuilder setChaincodeMetaInfLocation(File chaincodeMetaInfLocation) {
        this.chaincodeMetaInfLocation = chaincodeMetaInfLocation;
        return this;
    }

    @Override
    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        this.constructInstallProposal();
        return super.build();
    }

    private void constructInstallProposal() throws ProposalException {
        try {
            this.createNetModeTransaction();
        }
        catch (IOException exp) {
            logger.error((Object)exp);
            throw new ProposalException("IO Error while creating install proposal", exp);
        }
    }

    private void createNetModeTransaction() throws IOException {
        byte[] data;
        Chaincode.ChaincodeSpec.Type ccType;
        String dplang;
        logger.debug((Object)"createNetModeTransaction");
        if (null == this.chaincodeSource && this.chaincodeInputStream == null) {
            throw new IllegalArgumentException("Missing chaincodeSource or chaincodeInputStream in InstallRequest");
        }
        if (null != this.chaincodeSource && this.chaincodeInputStream != null) {
            throw new IllegalArgumentException("Both chaincodeSource and chaincodeInputStream in InstallRequest were set. Specify one or the other");
        }
        File projectSourceDir = null;
        String targetPathPrefix = null;
        File metainf = null;
        if (null != this.chaincodeMetaInfLocation) {
            if (!this.chaincodeMetaInfLocation.exists()) {
                throw new IllegalArgumentException(String.format("Directory to find chaincode META-INF %s does not exist", this.chaincodeMetaInfLocation.getAbsolutePath()));
            }
            if (!this.chaincodeMetaInfLocation.isDirectory()) {
                throw new IllegalArgumentException(String.format("Directory to find chaincode META-INF %s is not a directory", this.chaincodeMetaInfLocation.getAbsolutePath()));
            }
            metainf = new File(this.chaincodeMetaInfLocation, "META-INF");
            logger.trace((Object)("META-INF directory is " + metainf.getAbsolutePath()));
            if (!metainf.exists()) {
                throw new IllegalArgumentException(String.format("The META-INF directory does not exist in %s", this.chaincodeMetaInfLocation.getAbsolutePath()));
            }
            if (!metainf.isDirectory()) {
                throw new IllegalArgumentException(String.format("The META-INF in %s is not a directory.", this.chaincodeMetaInfLocation.getAbsolutePath()));
            }
            File[] files = metainf.listFiles();
            if (files == null) {
                throw new IllegalArgumentException("null for listFiles on: " + this.chaincodeMetaInfLocation.getAbsolutePath());
            }
            if (files.length < 1) {
                throw new IllegalArgumentException(String.format("The META-INF directory %s is empty.", metainf.getAbsolutePath()));
            }
            logger.trace((Object)String.format("chaincode META-INF found %s", metainf.getAbsolutePath()));
        }
        switch (this.chaincodeLanguage) {
            case GO_LANG: {
                if (Utils.isNullOrEmpty(this.chaincodePath)) {
                    throw new IllegalArgumentException("Missing chaincodePath in InstallRequest");
                }
                dplang = "Go";
                ccType = Chaincode.ChaincodeSpec.Type.GOLANG;
                if (null == this.chaincodeSource) break;
                projectSourceDir = Paths.get(this.chaincodeSource.toString(), "src", this.chaincodePath).toFile();
                targetPathPrefix = Paths.get("src", this.chaincodePath).toString();
                break;
            }
            case JAVA: {
                if (!Utils.isNullOrEmpty(this.chaincodePath)) {
                    throw new IllegalArgumentException("chaincodePath must be null for Java chaincode");
                }
                dplang = "Java";
                ccType = Chaincode.ChaincodeSpec.Type.JAVA;
                if (null == this.chaincodeSource) break;
                targetPathPrefix = "src";
                projectSourceDir = Paths.get(this.chaincodeSource.toString(), new String[0]).toFile();
                break;
            }
            case NODE: {
                if (!Utils.isNullOrEmpty(this.chaincodePath)) {
                    throw new IllegalArgumentException("chaincodePath must be null for Node chaincode");
                }
                dplang = "Node";
                ccType = Chaincode.ChaincodeSpec.Type.NODE;
                if (null == this.chaincodeSource) break;
                projectSourceDir = Paths.get(this.chaincodeSource.toString(), new String[0]).toFile();
                targetPathPrefix = "src";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected chaincode language: " + (Object)((Object)this.chaincodeLanguage));
            }
        }
        this.ccType(ccType);
        String chaincodeID = this.chaincodeName + "::" + this.chaincodePath + "::" + this.chaincodeVersion;
        if (this.chaincodeSource != null) {
            if (!projectSourceDir.exists()) {
                String message = "The project source directory does not exist: " + projectSourceDir.getAbsolutePath();
                logger.error((Object)message);
                throw new IllegalArgumentException(message);
            }
            if (!projectSourceDir.isDirectory()) {
                String message = "The project source directory is not a directory: " + projectSourceDir.getAbsolutePath();
                logger.error((Object)message);
                throw new IllegalArgumentException(message);
            }
            logger.info((Object)String.format("Installing '%s' language %s chaincode from directory: '%s' with source location: '%s'. chaincodePath:'%s'", chaincodeID, dplang, projectSourceDir.getAbsolutePath(), targetPathPrefix, this.chaincodePath));
            data = Utils.generateTarGz(projectSourceDir, targetPathPrefix, metainf);
            if (null != diagnosticFileDumper) {
                logger.trace((Object)String.format("Installing '%s' language %s chaincode from directory: '%s' with source location: '%s'. chaincodePath:'%s' tar file dump %s", chaincodeID, dplang, projectSourceDir.getAbsolutePath(), targetPathPrefix, this.chaincodePath, diagnosticFileDumper.createDiagnosticTarFile(data)));
            }
        } else {
            logger.info((Object)String.format("Installing '%s'  %s chaincode chaincodePath:'%s' from input stream", chaincodeID, dplang, this.chaincodePath));
            data = IOUtils.toByteArray((InputStream)this.chaincodeInputStream);
            if (null != diagnosticFileDumper) {
                logger.trace((Object)String.format("Installing '%s' language %s chaincode from input stream tar file dump %s", chaincodeID, dplang, diagnosticFileDumper.createDiagnosticTarFile(data)));
            }
        }
        Chaincode.ChaincodeDeploymentSpec depspec = ProtoUtils.createDeploymentSpec(ccType, this.chaincodeName, this.chaincodePath, this.chaincodeVersion, null, data);
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        argList.add(ByteString.copyFrom((String)this.action, (Charset)StandardCharsets.UTF_8));
        argList.add(depspec.toByteString());
        this.args(argList);
    }

    public void setChaincodeLanguage(TransactionRequest.Type chaincodeLanguage) {
        this.chaincodeLanguage = chaincodeLanguage;
    }

    public void chaincodeVersion(String chaincodeVersion) {
        this.chaincodeVersion = chaincodeVersion;
    }

    public void setChaincodeInputStream(InputStream chaincodeInputStream) {
        this.chaincodeInputStream = chaincodeInputStream;
    }
}

