/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.ChaincodeEndorsementPolicy;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.ChaincodeCollectionConfigurationException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.LSCCProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;

public class InstantiateProposalBuilder
extends LSCCProposalBuilder {
    private static final Log logger = LogFactory.getLog(InstantiateProposalBuilder.class);
    private String chaincodePath;
    private String chaincodeName;
    private List<String> argList;
    private String chaincodeVersion;
    private TransactionRequest.Type chaincodeType = TransactionRequest.Type.GO_LANG;
    private byte[] chaincodePolicy = null;
    private byte[] chaincodeCollectionConfiguration = null;
    protected String action = "deploy";

    public void setTransientMap(Map<String, byte[]> transientMap) throws InvalidArgumentException {
        this.transientMap = transientMap;
    }

    protected InstantiateProposalBuilder() {
    }

    public static InstantiateProposalBuilder newBuilder() {
        return new InstantiateProposalBuilder();
    }

    public InstantiateProposalBuilder chaincodePath(String chaincodePath) {
        this.chaincodePath = chaincodePath;
        return this;
    }

    public InstantiateProposalBuilder chaincodeName(String chaincodeName) {
        this.chaincodeName = chaincodeName;
        return this;
    }

    public InstantiateProposalBuilder chaincodeType(TransactionRequest.Type chaincodeType) {
        this.chaincodeType = chaincodeType;
        return this;
    }

    public void chaincodEndorsementPolicy(ChaincodeEndorsementPolicy policy) {
        if (policy != null) {
            this.chaincodePolicy = policy.getChaincodeEndorsementPolicyAsBytes();
        }
    }

    public void chaincodeCollectionConfiguration(ChaincodeCollectionConfiguration chaincodeCollectionConfiguration) throws ChaincodeCollectionConfigurationException {
        if (chaincodeCollectionConfiguration != null) {
            this.chaincodeCollectionConfiguration = chaincodeCollectionConfiguration.getAsBytes();
        }
    }

    public InstantiateProposalBuilder argss(List<String> argList) {
        this.argList = argList;
        return this;
    }

    @Override
    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        this.constructInstantiateProposal();
        return super.build();
    }

    private void constructInstantiateProposal() throws ProposalException, InvalidArgumentException {
        try {
            this.createNetModeTransaction();
        }
        catch (InvalidArgumentException exp) {
            logger.error((Object)exp);
            throw exp;
        }
        catch (Exception exp) {
            logger.error((Object)exp);
            throw new ProposalException("IO Error while creating install transaction", exp);
        }
    }

    private void createNetModeTransaction() throws InvalidArgumentException {
        if (this.chaincodeType == null) {
            throw new InvalidArgumentException("Chaincode type is required");
        }
        LinkedList<String> modlist = new LinkedList<String>();
        modlist.add("init");
        modlist.addAll(this.argList);
        switch (this.chaincodeType) {
            case JAVA: {
                this.ccType(Chaincode.ChaincodeSpec.Type.JAVA);
                break;
            }
            case NODE: {
                this.ccType(Chaincode.ChaincodeSpec.Type.NODE);
                break;
            }
            case GO_LANG: {
                this.ccType(Chaincode.ChaincodeSpec.Type.GOLANG);
                break;
            }
            default: {
                throw new InvalidArgumentException("Requested chaincode type is not supported: " + (Object)((Object)this.chaincodeType));
            }
        }
        Chaincode.ChaincodeDeploymentSpec depspec = ProtoUtils.createDeploymentSpec(this.ccType, this.chaincodeName, this.chaincodePath, this.chaincodeVersion, modlist, null);
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        argList.add(ByteString.copyFromUtf8((String)this.action));
        argList.add(ByteString.copyFromUtf8((String)this.context.getChannelID()));
        argList.add(depspec.toByteString());
        if (this.chaincodePolicy != null) {
            argList.add(ByteString.copyFrom((byte[])this.chaincodePolicy));
        } else if (null != this.chaincodeCollectionConfiguration) {
            argList.add(ByteString.EMPTY);
        }
        if (null != this.chaincodeCollectionConfiguration) {
            argList.add(ByteString.EMPTY);
            argList.add(ByteString.EMPTY);
            argList.add(ByteString.copyFrom((byte[])this.chaincodeCollectionConfiguration));
        }
        this.args(argList);
    }

    public void chaincodeVersion(String chaincodeVersion) {
        this.chaincodeVersion = chaincodeVersion;
    }
}

