/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.CSCCProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class JoinPeerProposalBuilder
extends CSCCProposalBuilder {
    private static final Log logger = LogFactory.getLog(JoinPeerProposalBuilder.class);

    public JoinPeerProposalBuilder genesisBlock(Common.Block genesisBlock) throws ProposalException {
        if (genesisBlock == null) {
            ProposalException exp = new ProposalException("No genesis block for Join proposal.");
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            throw exp;
        }
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        argList.add(ByteString.copyFrom((String)"JoinChain", (Charset)StandardCharsets.UTF_8));
        argList.add(genesisBlock.toByteString());
        this.args(argList);
        return this;
    }

    private JoinPeerProposalBuilder() {
    }

    @Override
    public JoinPeerProposalBuilder context(TransactionContext context) {
        super.context(context);
        return this;
    }

    public static JoinPeerProposalBuilder newBuilder() {
        return new JoinPeerProposalBuilder();
    }
}

