/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.transaction.LifecycleProposalBuilder;

public class LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder
extends LifecycleProposalBuilder {
    private static final Log logger = LogFactory.getLog(LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final Config config = Config.getConfig();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private Lifecycle.ApproveChaincodeDefinitionForMyOrgArgs.Builder builder = Lifecycle.ApproveChaincodeDefinitionForMyOrgArgs.newBuilder();
    static Boolean lifecycleInitRequiredDefault = null;

    protected LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder() {
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeEndorsementPlugin())) {
            this.builder.setEndorsementPlugin(config.getDefaultChaincodeEndorsementPlugin());
        }
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeValidationPlugin())) {
            this.builder.setValidationPlugin(config.getDefaultChaincodeValidationPlugin());
        }
        if (lifecycleInitRequiredDefault != null) {
            this.builder.setInitRequired(lifecycleInitRequiredDefault);
        }
        this.builder.setSource(Lifecycle.ChaincodeSource.newBuilder().setUnavailable(Lifecycle.ChaincodeSource.Unavailable.newBuilder().build()).build());
    }

    public static LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder newBuilder() {
        return new LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder();
    }

    @Override
    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        this.constructProposal();
        return super.build();
    }

    public void chaincodeName(String name) {
        this.builder.setName(name);
    }

    public void initRequired(boolean initRequired) {
        this.builder.setInitRequired(initRequired);
    }

    public void version(String version) {
        this.builder.setVersion(version);
    }

    public void setPackageId(String packageId) {
        this.builder.setSource(Lifecycle.ChaincodeSource.newBuilder().setLocalPackage(Lifecycle.ChaincodeSource.Local.newBuilder().setPackageId(packageId).build()));
    }

    public void sequence(long sequence) {
        this.builder.setSequence(sequence);
    }

    public void setValidationParamter(ByteString validationParamter) {
        this.builder.setValidationParameter(validationParamter);
    }

    public void collectionsConfig(Collection.CollectionConfigPackage collectionsConfig) {
        this.builder.setCollections(collectionsConfig);
    }

    void endorsementPolicy(byte[] endorsmentPolicyBytes) {
        this.builder.setValidationParameter(ByteString.copyFrom((byte[])endorsmentPolicyBytes));
    }

    private void constructProposal() {
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        argList.add(ByteString.copyFromUtf8((String)"ApproveChaincodeDefinitionForMyOrg"));
        argList.add(this.builder.build().toByteString());
        this.args(argList);
    }

    public void chaincodeCollectionConfiguration(Collection.CollectionConfigPackage collectionConfigPackage) {
        this.builder.setCollections(collectionConfigPackage);
    }

    public void chaincodeCodeEndorsementPlugin(String chaincodeEndorsementPlugin) {
        if (!Utils.isNullOrEmpty(chaincodeEndorsementPlugin)) {
            this.builder.setEndorsementPlugin(chaincodeEndorsementPlugin);
        }
    }

    public void chaincodeCodeValidationPlugin(String chaincodeValidationPlugin) {
        if (!Utils.isNullOrEmpty(chaincodeValidationPlugin)) {
            this.builder.setValidationPlugin(chaincodeValidationPlugin);
        }
    }

    static {
        lifecycleInitRequiredDefault = config.getLifecycleInitRequiredDefault();
    }
}

