/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.transaction.LifecycleProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public final class LifecycleCheckCommitReadinessBuilder
extends LifecycleProposalBuilder {
    private static final Config config = Config.getConfig();
    private static final Boolean lifecycleInitRequiredDefault = config.getLifecycleInitRequiredDefault();
    private final Lifecycle.CheckCommitReadinessArgs.Builder builder = Lifecycle.CheckCommitReadinessArgs.newBuilder();

    private LifecycleCheckCommitReadinessBuilder() {
        if (null != lifecycleInitRequiredDefault) {
            this.builder.setInitRequired(lifecycleInitRequiredDefault);
        }
    }

    @Override
    public LifecycleCheckCommitReadinessBuilder context(TransactionContext context) {
        super.context(context);
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeEndorsementPlugin())) {
            this.builder.setEndorsementPlugin(config.getDefaultChaincodeEndorsementPlugin());
        }
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeValidationPlugin())) {
            this.builder.setValidationPlugin(config.getDefaultChaincodeValidationPlugin());
        }
        if (lifecycleInitRequiredDefault != null) {
            this.builder.setInitRequired(lifecycleInitRequiredDefault);
        }
        return this;
    }

    public static LifecycleCheckCommitReadinessBuilder newBuilder() {
        return new LifecycleCheckCommitReadinessBuilder();
    }

    public void setSequence(long sequence) {
        this.builder.setSequence(sequence);
    }

    public void setName(String name) {
        this.builder.setName(name);
    }

    public void setVersion(String version) {
        this.builder.setVersion(version);
    }

    public void setEndorsementPlugin(String endorsementPlugin) {
        this.builder.setEndorsementPlugin(endorsementPlugin);
    }

    public void setValidationPlugin(String validationPlugin) {
        this.builder.setValidationPlugin(validationPlugin);
    }

    public void setValidationParameter(ByteString validationParameter) {
        this.builder.setValidationParameter(validationParameter);
    }

    public void setCollections(Collection.CollectionConfigPackage collectionConfigPackage) {
        this.builder.setCollections(collectionConfigPackage);
    }

    public void setInitRequired(boolean initRequired) {
        this.builder.setInitRequired(initRequired);
    }

    @Override
    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        argList.add(ByteString.copyFromUtf8((String)"CheckCommitReadiness"));
        argList.add(this.builder.build().toByteString());
        this.args(argList);
        return super.build();
    }
}

