/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.transaction.LifecycleProposalBuilder;

public class LifecycleCommitChaincodeDefinitionProposalBuilder
extends LifecycleProposalBuilder {
    private static final Log logger = LogFactory.getLog(LifecycleCommitChaincodeDefinitionProposalBuilder.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final Config config = Config.getConfig();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private Lifecycle.CommitChaincodeDefinitionArgs.Builder builder = Lifecycle.CommitChaincodeDefinitionArgs.newBuilder();
    static Boolean lifecycleInitRequiredDefault = null;

    protected LifecycleCommitChaincodeDefinitionProposalBuilder() {
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeEndorsementPlugin())) {
            this.builder.setEndorsementPlugin(config.getDefaultChaincodeEndorsementPlugin());
        }
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeValidationPlugin())) {
            this.builder.setValidationPlugin(config.getDefaultChaincodeValidationPlugin());
        }
        if (lifecycleInitRequiredDefault != null) {
            this.builder.setInitRequired(lifecycleInitRequiredDefault);
        }
    }

    public static LifecycleCommitChaincodeDefinitionProposalBuilder newBuilder() {
        return new LifecycleCommitChaincodeDefinitionProposalBuilder();
    }

    @Override
    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        this.constructProposal();
        return super.build();
    }

    public void chaincodeName(String name) {
        this.builder.setName(name);
    }

    public void initRequired(boolean initRequired) {
        this.builder.setInitRequired(initRequired);
    }

    public void version(String version) {
        this.builder.setVersion(version);
    }

    public void sequence(long sequence) {
        this.builder.setSequence(sequence);
    }

    public void setValidationParamter(ByteString validationParamter) {
        this.builder.setValidationParameter(validationParamter);
    }

    public void collectionsConfig(Collection.CollectionConfigPackage collectionsConfig) {
        this.builder.setCollections(collectionsConfig);
    }

    void endorsementPolicy(byte[] endorsmentPolicyBytes) {
        this.builder.setValidationParameter(ByteString.copyFrom((byte[])endorsmentPolicyBytes));
    }

    private void constructProposal() {
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        argList.add(ByteString.copyFromUtf8((String)"CommitChaincodeDefinition"));
        argList.add(this.builder.build().toByteString());
        this.args(argList);
    }

    public void chaincodeCollectionConfiguration(Collection.CollectionConfigPackage collectionConfigPackage) {
        this.builder.setCollections(collectionConfigPackage);
    }

    public void chaincodeCodeEndorsementPlugin(String chaincodeEndorsementPlugin) {
        if (!Utils.isNullOrEmpty(chaincodeEndorsementPlugin)) {
            this.builder.setEndorsementPlugin(chaincodeEndorsementPlugin);
        }
    }

    public void chaincodeCodeValidationPlugin(String chaincodeValidationPlugin) {
        if (!Utils.isNullOrEmpty(chaincodeValidationPlugin)) {
            this.builder.setValidationPlugin(chaincodeValidationPlugin);
        }
    }

    static {
        lifecycleInitRequiredDefault = config.getLifecycleInitRequiredDefault();
    }
}

