/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.transaction.LifecycleProposalBuilder;

public class LifecycleInstallProposalBuilder
extends LifecycleProposalBuilder {
    private static final Log logger = LogFactory.getLog(LifecycleInstallProposalBuilder.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final Config config = Config.getConfig();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private String chaincodePath;
    private File chaincodeSource;
    private TransactionRequest.Type chaincodeLanguage;
    protected String action = "InstallChaincode";
    private InputStream chaincodeInputStream;
    private File chaincodeMetaInfLocation;
    private byte[] chaincodeBytes;

    protected LifecycleInstallProposalBuilder() {
    }

    public static LifecycleInstallProposalBuilder newBuilder() {
        return new LifecycleInstallProposalBuilder();
    }

    public LifecycleInstallProposalBuilder chaincodePath(String chaincodePath) {
        this.chaincodePath = chaincodePath;
        return this;
    }

    public LifecycleInstallProposalBuilder setChaincodeSource(File chaincodeSource) {
        this.chaincodeSource = chaincodeSource;
        return this;
    }

    public LifecycleInstallProposalBuilder setChaincodeBytes(byte[] chaincodeBytes) {
        this.chaincodeBytes = chaincodeBytes;
        return this;
    }

    public LifecycleInstallProposalBuilder setChaincodeMetaInfLocation(File chaincodeMetaInfLocation) {
        this.chaincodeMetaInfLocation = chaincodeMetaInfLocation;
        return this;
    }

    @Override
    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        this.constructInstallProposal();
        return super.build();
    }

    private void constructInstallProposal() throws ProposalException {
        this.createNetModeTransaction();
    }

    private void createNetModeTransaction() {
        logger.debug((Object)"createNetModeTransaction");
        ArrayList<ByteString> argList = new ArrayList<ByteString>();
        Lifecycle.InstallChaincodeArgs installChaincodeArgs = Lifecycle.InstallChaincodeArgs.newBuilder().setChaincodeInstallPackage(ByteString.copyFrom((byte[])this.chaincodeBytes)).build();
        argList.add(ByteString.copyFromUtf8((String)this.action));
        argList.add(ByteString.copyFrom((byte[])installChaincodeArgs.toByteArray()));
        this.args(argList);
    }

    public void setChaincodeLanguage(TransactionRequest.Type chaincodeLanguage) {
        this.chaincodeLanguage = chaincodeLanguage;
    }
}

