/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class ProposalBuilder {
    private static final Log logger = LogFactory.getLog(ProposalBuilder.class);
    private static final boolean IS_DEBUG_LEVEL = logger.isDebugEnabled();
    private Chaincode.ChaincodeID chaincodeID;
    protected List<ByteString> argList;
    protected TransactionContext context;
    protected TransactionRequest request;
    protected Chaincode.ChaincodeSpec.Type ccType = Chaincode.ChaincodeSpec.Type.GOLANG;
    protected Map<String, byte[]> transientMap = null;
    private String channelID;
    private boolean isInit = false;

    protected void setInit(boolean init) {
        this.isInit = init;
    }

    protected ProposalBuilder() {
    }

    public static ProposalBuilder newBuilder() {
        return new ProposalBuilder();
    }

    public ProposalBuilder chaincodeID(Chaincode.ChaincodeID chaincodeID) {
        this.chaincodeID = chaincodeID;
        return this;
    }

    public ProposalBuilder args(List<ByteString> argList) {
        this.argList = argList;
        return this;
    }

    public ProposalBuilder context(TransactionContext context) {
        this.context = context;
        if (null == this.channelID) {
            this.channelID = context.getChannel().getName();
        }
        return this;
    }

    public ProposalBuilder request(TransactionRequest request) throws InvalidArgumentException {
        this.request = request;
        this.chaincodeID(request.getFabricChaincodeID());
        switch (request.getChaincodeLanguage()) {
            case JAVA: {
                this.ccType(Chaincode.ChaincodeSpec.Type.JAVA);
                break;
            }
            case NODE: {
                this.ccType(Chaincode.ChaincodeSpec.Type.NODE);
                break;
            }
            case GO_LANG: {
                this.ccType(Chaincode.ChaincodeSpec.Type.GOLANG);
                break;
            }
            default: {
                throw new InvalidArgumentException("Requested chaincode type is not supported: " + (Object)((Object)request.getChaincodeLanguage()));
            }
        }
        this.transientMap = request.getTransientMap();
        this.isInit = request.isInit();
        return this;
    }

    public ProposalPackage.Proposal build() throws ProposalException, InvalidArgumentException {
        if (this.request != null && this.request.noChannelID()) {
            this.channelID = "";
        }
        return this.createFabricProposal(this.channelID, this.chaincodeID, this.isInit);
    }

    private ProposalPackage.Proposal createFabricProposal(String channelID, Chaincode.ChaincodeID chaincodeID, boolean isInit) {
        if (null == this.transientMap) {
            this.transientMap = Collections.emptyMap();
        }
        if (IS_DEBUG_LEVEL) {
            for (Map.Entry<String, byte[]> tme : this.transientMap.entrySet()) {
                logger.debug((Object)String.format("transientMap('%s', '%s'))", Utils.logString(tme.getKey()), Utils.logString(new String(tme.getValue(), StandardCharsets.UTF_8))));
            }
        }
        ProposalPackage.ChaincodeHeaderExtension chaincodeHeaderExtension = ProposalPackage.ChaincodeHeaderExtension.newBuilder().setChaincodeId(chaincodeID).build();
        Common.ChannelHeader chainHeader = ProtoUtils.createChannelHeader(Common.HeaderType.ENDORSER_TRANSACTION, this.context.getTxID(), channelID, this.context.getEpoch(), this.context.getFabricTimestamp(), chaincodeHeaderExtension, null);
        Chaincode.ChaincodeInvocationSpec chaincodeInvocationSpec = this.createChaincodeInvocationSpec(chaincodeID, this.ccType, isInit);
        Map<String, ByteString> bsm = Collections.emptyMap();
        if (this.transientMap != null) {
            bsm = new HashMap<String, ByteString>(this.transientMap.size());
            for (Map.Entry<String, byte[]> tme : this.transientMap.entrySet()) {
                bsm.put(tme.getKey(), ByteString.copyFrom((byte[])tme.getValue()));
            }
        }
        ProposalPackage.ChaincodeProposalPayload payload = ProposalPackage.ChaincodeProposalPayload.newBuilder().setInput(chaincodeInvocationSpec.toByteString()).putAllTransientMap(bsm).build();
        Common.Header header = Common.Header.newBuilder().setSignatureHeader(ProtoUtils.getSignatureHeaderAsByteString(this.context)).setChannelHeader(chainHeader.toByteString()).build();
        return ProposalPackage.Proposal.newBuilder().setHeader(header.toByteString()).setPayload(payload.toByteString()).build();
    }

    private Chaincode.ChaincodeInvocationSpec createChaincodeInvocationSpec(Chaincode.ChaincodeID chaincodeID, Chaincode.ChaincodeSpec.Type langType, boolean isInit) {
        List<Object> allArgs = new ArrayList<ByteString>();
        if (this.argList != null && this.argList.size() > 0) {
            allArgs = this.argList;
        } else if (this.request != null) {
            ArrayList<byte[]> argBytes;
            allArgs.add(ByteString.copyFrom((String)this.request.getFcn(), (Charset)StandardCharsets.UTF_8));
            ArrayList<String> args = this.request.getArgs();
            if (args != null && args.size() > 0) {
                for (String arg : args) {
                    allArgs.add(ByteString.copyFrom((byte[])arg.getBytes(StandardCharsets.UTF_8)));
                }
            }
            if ((argBytes = this.request.getArgBytes()) != null && argBytes.size() > 0) {
                for (byte[] byArray : argBytes) {
                    allArgs.add(ByteString.copyFrom((byte[])byArray));
                }
            }
        }
        if (IS_DEBUG_LEVEL) {
            StringBuilder logout = new StringBuilder(1000);
            logout.append(String.format("ChaincodeInvocationSpec type: %s, chaincode name: %s, chaincode path: %s, chaincode version: %s, isInit: %b", langType.name(), chaincodeID.getName(), chaincodeID.getPath(), chaincodeID.getVersion(), isInit));
            String sep = "";
            logout.append(", args(");
            for (ByteString byteString : allArgs) {
                logout.append(sep).append("\"").append(Utils.logString(new String(byteString.toByteArray(), StandardCharsets.UTF_8))).append("\"");
                sep = ", ";
            }
            logout.append(")");
            logger.debug((Object)logout.toString());
        }
        Chaincode.ChaincodeInput chaincodeInput = Chaincode.ChaincodeInput.newBuilder().addAllArgs(allArgs).setIsInit(isInit).build();
        Chaincode.ChaincodeSpec chaincodeSpec = Chaincode.ChaincodeSpec.newBuilder().setType(langType).setChaincodeId(chaincodeID).setInput(chaincodeInput).build();
        return Chaincode.ChaincodeInvocationSpec.newBuilder().setChaincodeSpec(chaincodeSpec).build();
    }

    public ProposalBuilder ccType(Chaincode.ChaincodeSpec.Type ccType) {
        this.ccType = ccType;
        return this;
    }
}

