/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.common.Configtx;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.protos.orderer.Ab;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;
import org.hyperledger.fabric.sdk.security.CryptoPrimitives;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public final class ProtoUtils {
    private static final Log logger = LogFactory.getLog(ProtoUtils.class);
    private static final boolean isDebugLevel = logger.isDebugEnabled();
    public static CryptoSuite suite;

    private ProtoUtils() {
    }

    public static Common.ChannelHeader createChannelHeader(Common.HeaderType type, String txID, String channelID, long epoch, Timestamp timeStamp, ProposalPackage.ChaincodeHeaderExtension chaincodeHeaderExtension, byte[] tlsCertHash) {
        if (isDebugLevel) {
            String tlschs = "";
            if (tlsCertHash != null) {
                tlschs = DatatypeConverter.printHexBinary((byte[])tlsCertHash);
            }
            logger.debug((Object)String.format("ChannelHeader: type: %s, version: 1, Txid: %s, channelId: %s, epoch %d, clientTLSCertificate digest: %s", type.name(), txID, channelID, epoch, tlschs));
        }
        Common.ChannelHeader.Builder ret = Common.ChannelHeader.newBuilder().setType(type.getNumber()).setVersion(1).setTxId(txID).setChannelId(channelID).setTimestamp(timeStamp).setEpoch(epoch);
        if (null != chaincodeHeaderExtension) {
            ret.setExtension(chaincodeHeaderExtension.toByteString());
        }
        if (tlsCertHash != null) {
            ret.setTlsCertHash(ByteString.copyFrom((byte[])tlsCertHash));
        }
        return ret.build();
    }

    public static Chaincode.ChaincodeDeploymentSpec createDeploymentSpec(Chaincode.ChaincodeSpec.Type ccType, String name, String chaincodePath, String chaincodeVersion, List<String> args, byte[] codePackage) {
        Chaincode.ChaincodeID.Builder chaincodeIDBuilder = Chaincode.ChaincodeID.newBuilder().setName(name).setVersion(chaincodeVersion);
        if (chaincodePath != null) {
            chaincodeIDBuilder = chaincodeIDBuilder.setPath(chaincodePath);
        }
        Chaincode.ChaincodeID chaincodeID = chaincodeIDBuilder.build();
        ArrayList<ByteString> argList = new ArrayList<ByteString>(args == null ? 0 : args.size());
        if (args != null && args.size() != 0) {
            for (String arg : args) {
                argList.add(ByteString.copyFrom((byte[])arg.getBytes(StandardCharsets.UTF_8)));
            }
        }
        Chaincode.ChaincodeInput chaincodeInput = Chaincode.ChaincodeInput.newBuilder().addAllArgs(argList).setIsInit(false).build();
        Chaincode.ChaincodeSpec chaincodeSpec = Chaincode.ChaincodeSpec.newBuilder().setType(ccType).setChaincodeId(chaincodeID).setInput(chaincodeInput).build();
        if (isDebugLevel) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("ChaincodeDeploymentSpec chaincode cctype: ").append(ccType.name()).append(", name:").append(chaincodeID.getName()).append(", path: ").append(chaincodeID.getPath()).append(", version: ").append(chaincodeID.getVersion());
            String sep = "";
            sb.append(" args(");
            for (ByteString x : argList) {
                sb.append(sep).append("\"").append(Utils.logString(new String(x.toByteArray(), StandardCharsets.UTF_8))).append("\"");
                sep = ", ";
            }
            sb.append(")");
            logger.debug((Object)sb.toString());
        }
        Chaincode.ChaincodeDeploymentSpec.Builder chaincodeDeploymentSpecBuilder = Chaincode.ChaincodeDeploymentSpec.newBuilder().setChaincodeSpec(chaincodeSpec);
        if (codePackage != null) {
            chaincodeDeploymentSpecBuilder.setCodePackage(ByteString.copyFrom((byte[])codePackage));
        }
        return chaincodeDeploymentSpecBuilder.build();
    }

    public static ByteString getSignatureHeaderAsByteString(TransactionContext transactionContext) {
        return ProtoUtils.getSignatureHeaderAsByteString(transactionContext.getUser(), transactionContext);
    }

    public static ByteString getSignatureHeaderAsByteString(User user, TransactionContext transactionContext) {
        Identities.SerializedIdentity identity = transactionContext.getSerializedIdentity();
        if (isDebugLevel) {
            Enrollment enrollment = user.getEnrollment();
            String cert = enrollment.getCert();
            logger.debug((Object)String.format(" User: %s Certificate: %s", user.getName(), cert == null ? "null" : Utils.toHexString(cert.getBytes(StandardCharsets.UTF_8))));
            if (enrollment instanceof X509Enrollment) {
                CryptoPrimitives cp;
                byte[] der;
                if (null == suite) {
                    try {
                        suite = CryptoSuite.Factory.getCryptoSuite();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (suite instanceof CryptoPrimitives && null != (der = (cp = (CryptoPrimitives)suite).certificateToDER(cert)) && der.length > 0) {
                    cert = Utils.toHexString(suite.hash(der));
                }
            }
            if (isDebugLevel) {
                logger.debug((Object)String.format("SignatureHeader: nonce: %s, User:%s, MSPID: %s, idBytes: %s", Utils.toHexString(transactionContext.getNonce()), user.getName(), identity.getMspid(), Utils.toHexString(cert)));
            }
        }
        return Common.SignatureHeader.newBuilder().setCreator(identity.toByteString()).setNonce(transactionContext.getNonce()).build().toByteString();
    }

    public static Identities.SerializedIdentity createSerializedIdentity(User user) {
        return Identities.SerializedIdentity.newBuilder().setIdBytes(ByteString.copyFromUtf8((String)user.getEnrollment().getCert())).setMspid(user.getMspId()).build();
    }

    public static Timestamp getCurrentFabricTimestamp() {
        Instant time = Instant.now();
        return Timestamp.newBuilder().setSeconds(time.getEpochSecond()).setNanos(time.getNano()).build();
    }

    public static Date getDateFromTimestamp(Timestamp timestamp) {
        return new Date(Timestamps.toMillis((Timestamp)timestamp));
    }

    static Timestamp getTimestampFromDate(Date date) {
        long millis = date.getTime();
        return Timestamp.newBuilder().setSeconds(millis / 1000L).setNanos((int)(millis % 1000L * 1000000L)).build();
    }

    public static Common.Envelope createSeekInfoEnvelope(TransactionContext transactionContext, Ab.SeekInfo seekInfo, byte[] tlsCertHash) throws CryptoException, InvalidArgumentException {
        Common.ChannelHeader seekInfoHeader = ProtoUtils.createChannelHeader(Common.HeaderType.DELIVER_SEEK_INFO, transactionContext.getTxID(), transactionContext.getChannelID(), transactionContext.getEpoch(), transactionContext.getFabricTimestamp(), null, tlsCertHash);
        Common.SignatureHeader signatureHeader = Common.SignatureHeader.newBuilder().setCreator(transactionContext.getIdentity().toByteString()).setNonce(transactionContext.getNonce()).build();
        Common.Header seekHeader = Common.Header.newBuilder().setSignatureHeader(signatureHeader.toByteString()).setChannelHeader(seekInfoHeader.toByteString()).build();
        Common.Payload seekPayload = Common.Payload.newBuilder().setHeader(seekHeader).setData(seekInfo.toByteString()).build();
        return Common.Envelope.newBuilder().setSignature(transactionContext.signByteString(seekPayload.toByteArray())).setPayload(seekPayload.toByteString()).build();
    }

    public static Common.Envelope createSeekInfoEnvelope(TransactionContext transactionContext, Ab.SeekPosition startPosition, Ab.SeekPosition stopPosition, Ab.SeekInfo.SeekBehavior seekBehavior, byte[] tlsCertHash) throws CryptoException, InvalidArgumentException {
        return ProtoUtils.createSeekInfoEnvelope(transactionContext, Ab.SeekInfo.newBuilder().setStart(startPosition).setStop(stopPosition).setBehavior(seekBehavior).build(), tlsCertHash);
    }

    public static boolean computeUpdate(String channelId, Configtx.Config original, Configtx.Config update, Configtx.ConfigUpdate.Builder configUpdateBuilder) {
        Configtx.ConfigGroup.Builder readSetBuilder = Configtx.ConfigGroup.newBuilder();
        Configtx.ConfigGroup.Builder writeSetBuilder = Configtx.ConfigGroup.newBuilder();
        if (ProtoUtils.computeGroupUpdate(original.getChannelGroup(), update.getChannelGroup(), readSetBuilder, writeSetBuilder)) {
            configUpdateBuilder.setReadSet(readSetBuilder.build()).setWriteSet(writeSetBuilder.build()).setChannelId(channelId);
            return true;
        }
        return false;
    }

    private static boolean computeGroupUpdate(Configtx.ConfigGroup original, Configtx.ConfigGroup updated, Configtx.ConfigGroup.Builder readSetBuilder, Configtx.ConfigGroup.Builder writeSetBuilder) {
        GeneratedMessageV3 value;
        String name;
        HashMap<String, Configtx.ConfigPolicy> readSetPolicies = new HashMap<String, Configtx.ConfigPolicy>();
        HashMap<String, Configtx.ConfigPolicy> writeSetPolicies = new HashMap<String, Configtx.ConfigPolicy>();
        HashMap<String, Configtx.ConfigPolicy> sameSetPolicies = new HashMap<String, Configtx.ConfigPolicy>();
        boolean policiesMembersUpdated = ProtoUtils.computePoliciesMapUpdate(original.getPoliciesMap(), updated.getPoliciesMap(), writeSetPolicies, sameSetPolicies);
        HashMap<String, Configtx.ConfigValue> readSetValues = new HashMap<String, Configtx.ConfigValue>();
        HashMap<String, Configtx.ConfigValue> writeSetValues = new HashMap<String, Configtx.ConfigValue>();
        HashMap<String, Configtx.ConfigValue> sameSetValues = new HashMap<String, Configtx.ConfigValue>();
        boolean valuesMembersUpdated = ProtoUtils.computeValuesMapUpdate(original.getValuesMap(), updated.getValuesMap(), writeSetValues, sameSetValues);
        HashMap<String, Configtx.ConfigGroup> readSetGroups = new HashMap<String, Configtx.ConfigGroup>();
        HashMap<String, Configtx.ConfigGroup> writeSetGroups = new HashMap<String, Configtx.ConfigGroup>();
        HashMap<String, Configtx.ConfigGroup> sameSetGroups = new HashMap<String, Configtx.ConfigGroup>();
        boolean groupsMembersUpdated = ProtoUtils.computeGroupsMapUpdate(original.getGroupsMap(), updated.getGroupsMap(), readSetGroups, writeSetGroups, sameSetGroups);
        if (!policiesMembersUpdated && !valuesMembersUpdated && !groupsMembersUpdated && original.getModPolicy().equals(updated.getModPolicy())) {
            if (writeSetValues.isEmpty() && writeSetPolicies.isEmpty() && writeSetGroups.isEmpty() && readSetGroups.isEmpty()) {
                readSetBuilder.setVersion(original.getVersion());
                writeSetBuilder.setVersion(original.getVersion());
                return false;
            }
            readSetBuilder.setVersion(original.getVersion()).putAllGroups(readSetGroups);
            writeSetBuilder.setVersion(original.getVersion()).putAllPolicies(writeSetPolicies).putAllValues(writeSetValues).putAllGroups(writeSetGroups);
            return true;
        }
        for (Map.Entry i : sameSetPolicies.entrySet()) {
            name = (String)i.getKey();
            value = (Configtx.ConfigPolicy)i.getValue();
            readSetPolicies.put(name, (Configtx.ConfigPolicy)value);
            writeSetPolicies.put(name, (Configtx.ConfigPolicy)value);
        }
        for (Map.Entry i : sameSetValues.entrySet()) {
            name = (String)i.getKey();
            value = (Configtx.ConfigValue)i.getValue();
            readSetValues.put(name, (Configtx.ConfigValue)value);
            writeSetValues.put(name, (Configtx.ConfigValue)value);
        }
        for (Map.Entry i : sameSetGroups.entrySet()) {
            name = (String)i.getKey();
            value = (Configtx.ConfigGroup)i.getValue();
            readSetGroups.put(name, (Configtx.ConfigGroup)value);
            writeSetGroups.put(name, (Configtx.ConfigGroup)value);
        }
        readSetBuilder.setVersion(original.getVersion()).putAllPolicies(readSetPolicies).putAllValues(readSetValues).putAllGroups(readSetGroups);
        writeSetBuilder.setVersion(original.getVersion() + 1L).putAllPolicies(writeSetPolicies).putAllValues(writeSetValues).setModPolicy(updated.getModPolicy()).putAllGroups(writeSetGroups);
        return true;
    }

    public static boolean computeGroupsMapUpdate(Map<String, Configtx.ConfigGroup> original, Map<String, Configtx.ConfigGroup> updated, Map<String, Configtx.ConfigGroup> readSet, Map<String, Configtx.ConfigGroup> writeSet, Map<String, Configtx.ConfigGroup> sameSet) {
        String groupName;
        boolean updatedMembers = false;
        for (Map.Entry<String, Configtx.ConfigGroup> i : original.entrySet()) {
            Configtx.ConfigGroup.Builder writeSetBuilder;
            Configtx.ConfigGroup.Builder readSetBuilder;
            groupName = i.getKey();
            Configtx.ConfigGroup originalGroup = i.getValue();
            if (!updated.containsKey(groupName) || null == updated.get(groupName)) {
                updatedMembers = true;
                continue;
            }
            Configtx.ConfigGroup updatedGroup = updated.get(groupName);
            if (!ProtoUtils.computeGroupUpdate(originalGroup, updatedGroup, readSetBuilder = Configtx.ConfigGroup.newBuilder(), writeSetBuilder = Configtx.ConfigGroup.newBuilder())) {
                sameSet.put(groupName, readSetBuilder.build());
                continue;
            }
            readSet.put(groupName, readSetBuilder.build());
            writeSet.put(groupName, writeSetBuilder.build());
        }
        for (Map.Entry<String, Configtx.ConfigGroup> i : updated.entrySet()) {
            groupName = i.getKey();
            Configtx.ConfigGroup updatedConfigGroup = i.getValue();
            if (original.containsKey(groupName) && null != original.get(groupName)) continue;
            updatedMembers = true;
            Configtx.ConfigGroup.Builder readSetBuilder = Configtx.ConfigGroup.newBuilder();
            Configtx.ConfigGroup.Builder writeSetBuilder = Configtx.ConfigGroup.newBuilder();
            ProtoUtils.computeGroupUpdate(Configtx.ConfigGroup.newBuilder().build(), updatedConfigGroup, readSetBuilder, writeSetBuilder);
            writeSet.put(groupName, Configtx.ConfigGroup.newBuilder().setVersion(0L).setModPolicy(updatedConfigGroup.getModPolicy()).putAllPolicies(writeSetBuilder.getPoliciesMap()).putAllValues(writeSetBuilder.getValuesMap()).putAllGroups(writeSetBuilder.getGroupsMap()).build());
        }
        return updatedMembers;
    }

    private static boolean computeValuesMapUpdate(Map<String, Configtx.ConfigValue> original, Map<String, Configtx.ConfigValue> updated, Map<String, Configtx.ConfigValue> writeSet, Map<String, Configtx.ConfigValue> sameSet) {
        String valueName;
        boolean updatedMembers = false;
        for (Map.Entry<String, Configtx.ConfigValue> i : original.entrySet()) {
            valueName = i.getKey();
            Configtx.ConfigValue originalValue = i.getValue();
            if (!updated.containsKey(valueName) || null == updated.get(valueName)) {
                updatedMembers = true;
                continue;
            }
            Configtx.ConfigValue updatedValue = updated.get(valueName);
            if (originalValue.getModPolicy().equals(updatedValue.getModPolicy()) && originalValue.getValue().equals((Object)updatedValue.getValue())) {
                sameSet.put(valueName, Configtx.ConfigValue.newBuilder().setVersion(originalValue.getVersion()).build());
                continue;
            }
            writeSet.put(valueName, Configtx.ConfigValue.newBuilder().setVersion(originalValue.getVersion() + 1L).setModPolicy(updatedValue.getModPolicy()).setValue(updatedValue.getValue()).build());
        }
        for (Map.Entry<String, Configtx.ConfigValue> i : updated.entrySet()) {
            valueName = i.getKey();
            Configtx.ConfigValue updatedValue = i.getValue();
            if (original.containsKey(valueName) && null != original.get(valueName)) continue;
            updatedMembers = true;
            writeSet.put(valueName, Configtx.ConfigValue.newBuilder().setVersion(0L).setModPolicy(updatedValue.getModPolicy()).setValue(updatedValue.getValue()).build());
        }
        return updatedMembers;
    }

    private static boolean computePoliciesMapUpdate(Map<String, Configtx.ConfigPolicy> original, Map<String, Configtx.ConfigPolicy> updated, Map<String, Configtx.ConfigPolicy> writeSet, Map<String, Configtx.ConfigPolicy> sameSet) {
        String policyName;
        boolean updatedMembers = false;
        for (Map.Entry<String, Configtx.ConfigPolicy> i : original.entrySet()) {
            policyName = i.getKey();
            Configtx.ConfigPolicy originalPolicy = i.getValue();
            if (!updated.containsKey(policyName) || null == updated.get(policyName)) {
                updatedMembers = true;
                continue;
            }
            Configtx.ConfigPolicy updatedPolicy = updated.get(policyName);
            if (originalPolicy.getModPolicy().equals(updatedPolicy.getModPolicy()) && originalPolicy.toByteString().equals((Object)updatedPolicy.toByteString())) {
                sameSet.put(policyName, Configtx.ConfigPolicy.newBuilder().setVersion(originalPolicy.getVersion()).build());
                continue;
            }
            writeSet.put(policyName, Configtx.ConfigPolicy.newBuilder().setVersion(originalPolicy.getVersion() + 1L).setModPolicy(updatedPolicy.getModPolicy()).setPolicy(updatedPolicy.getPolicy().newBuilderForType().build()).build());
        }
        for (Map.Entry<String, Configtx.ConfigPolicy> i : updated.entrySet()) {
            policyName = i.getKey();
            Configtx.ConfigPolicy updatedPolicy = i.getValue();
            if (original.containsKey(policyName) && null != original.get(policyName)) continue;
            updatedMembers = true;
            writeSet.put(policyName, Configtx.ConfigPolicy.newBuilder().setVersion(0L).setModPolicy(updatedPolicy.getModPolicy()).setPolicy(updatedPolicy.getPolicy().newBuilderForType().build()).build());
        }
        return updatedMembers;
    }
}

