/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;

public class TransactionBuilder {
    private static final Log logger = LogFactory.getLog(TransactionBuilder.class);
    private static final Config config = Config.getConfig();
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private ProposalPackage.Proposal chaincodeProposal;
    private Collection<ProposalResponsePackage.Endorsement> endorsements;
    private ByteString proposalResponsePayload;

    public static TransactionBuilder newBuilder() {
        return new TransactionBuilder();
    }

    public TransactionBuilder chaincodeProposal(ProposalPackage.Proposal chaincodeProposal) {
        this.chaincodeProposal = chaincodeProposal;
        return this;
    }

    public TransactionBuilder endorsements(Collection<ProposalResponsePackage.Endorsement> endorsements) {
        this.endorsements = endorsements;
        return this;
    }

    public TransactionBuilder proposalResponsePayload(ByteString proposalResponsePayload) {
        this.proposalResponsePayload = proposalResponsePayload;
        return this;
    }

    public Common.Payload build() throws InvalidProtocolBufferException {
        return this.createTransactionCommonPayload(this.chaincodeProposal, this.proposalResponsePayload, this.endorsements);
    }

    private Common.Payload createTransactionCommonPayload(ProposalPackage.Proposal chaincodeProposal, ByteString proposalResponsePayload, Collection<ProposalResponsePackage.Endorsement> endorsements) throws InvalidProtocolBufferException {
        TransactionPackage.ChaincodeEndorsedAction.Builder chaincodeEndorsedActionBuilder = TransactionPackage.ChaincodeEndorsedAction.newBuilder();
        chaincodeEndorsedActionBuilder.setProposalResponsePayload(proposalResponsePayload);
        chaincodeEndorsedActionBuilder.addAllEndorsements(endorsements);
        TransactionPackage.ChaincodeActionPayload.Builder chaincodeActionPayloadBuilder = TransactionPackage.ChaincodeActionPayload.newBuilder();
        chaincodeActionPayloadBuilder.setAction(chaincodeEndorsedActionBuilder.build());
        ProposalPackage.ChaincodeProposalPayload.Builder chaincodeProposalPayloadNoTransBuilder = ProposalPackage.ChaincodeProposalPayload.newBuilder();
        chaincodeProposalPayloadNoTransBuilder.mergeFrom(chaincodeProposal.getPayload());
        chaincodeProposalPayloadNoTransBuilder.clearTransientMap();
        chaincodeActionPayloadBuilder.setChaincodeProposalPayload(chaincodeProposalPayloadNoTransBuilder.build().toByteString());
        TransactionPackage.TransactionAction.Builder transactionActionBuilder = TransactionPackage.TransactionAction.newBuilder();
        Common.Header header = Common.Header.parseFrom(chaincodeProposal.getHeader());
        if (config.extraLogLevel(10) && null != diagnosticFileDumper) {
            StringBuilder sb = new StringBuilder(10000);
            sb.append("transaction header bytes:" + Arrays.toString(header.toByteArray()));
            sb.append("\n");
            sb.append("transaction header sig bytes:" + Arrays.toString(header.getSignatureHeader().toByteArray()));
            logger.trace((Object)("transaction header:  " + diagnosticFileDumper.createDiagnosticFile(sb.toString())));
        }
        transactionActionBuilder.setHeader(header.getSignatureHeader());
        TransactionPackage.ChaincodeActionPayload chaincodeActionPayload = chaincodeActionPayloadBuilder.build();
        if (config.extraLogLevel(10) && null != diagnosticFileDumper) {
            logger.trace((Object)("transactionActionBuilder.setPayload: " + diagnosticFileDumper.createDiagnosticFile(Arrays.toString(chaincodeActionPayload.toByteString().toByteArray()))));
        }
        transactionActionBuilder.setPayload(chaincodeActionPayload.toByteString());
        TransactionPackage.Transaction.Builder transactionBuilder = TransactionPackage.Transaction.newBuilder();
        transactionBuilder.addActions(transactionActionBuilder.build());
        Common.Payload.Builder payload = Common.Payload.newBuilder();
        payload.setHeader(header);
        payload.setData(transactionBuilder.build().toByteString());
        return payload.build();
    }
}

