/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk.transaction;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.identity.IdentityFactory;
import org.hyperledger.fabric.sdk.identity.SigningIdentity;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;

public class TransactionContext {
    private static final Config config = Config.getConfig();
    private final ByteString nonce = ByteString.copyFrom((byte[])Utils.generateNonce());
    private final CryptoSuite cryptoPrimitives;
    private final User user;
    private final Channel channel;
    private final String txID;
    private final Identities.SerializedIdentity identity;
    Timestamp currentTimeStamp = null;
    private boolean verify = true;
    private long proposalWaitTime = config.getProposalWaitTime();
    private SigningIdentity signingIdentity;
    private final String toString;

    public TransactionContext(Channel channel, User user, CryptoSuite cryptoPrimitives) {
        this.user = user;
        this.channel = channel;
        this.verify = !"".equals(channel.getName());
        this.cryptoPrimitives = cryptoPrimitives;
        this.signingIdentity = IdentityFactory.getSigningIdentity(cryptoPrimitives, user);
        this.identity = this.signingIdentity.createSerializedIdentity();
        ByteString no = this.getNonce();
        ByteString comp = no.concat(this.identity.toByteString());
        byte[] txh = cryptoPrimitives.hash(comp.toByteArray());
        this.txID = new String(Utils.toHexString(txh));
        this.toString = "TransactionContext{ txID: " + this.txID + ", mspid: " + user.getMspId() + ", user: " + user.getName() + "}";
    }

    public CryptoSuite getCryptoPrimitives() {
        return this.cryptoPrimitives;
    }

    public Identities.SerializedIdentity getIdentity() {
        return this.identity;
    }

    public long getEpoch() {
        return 0L;
    }

    public User getUser() {
        return this.user;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getProposalWaitTime() {
        return this.proposalWaitTime;
    }

    public void setProposalWaitTime(long proposalWaitTime) {
        this.proposalWaitTime = proposalWaitTime;
    }

    public Timestamp getFabricTimestamp() {
        if (this.currentTimeStamp == null) {
            this.currentTimeStamp = ProtoUtils.getCurrentFabricTimestamp();
        }
        return this.currentTimeStamp;
    }

    public ByteString getNonce() {
        return this.nonce;
    }

    public void verify(boolean verify) {
        this.verify = verify;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public String getChannelID() {
        return this.getChannel().getName();
    }

    public String getTxID() {
        return this.txID;
    }

    public byte[] sign(byte[] b) throws CryptoException, InvalidArgumentException {
        return this.signingIdentity.sign(b);
    }

    public ByteString signByteString(byte[] b) throws CryptoException, InvalidArgumentException {
        return ByteString.copyFrom((byte[])this.sign(b));
    }

    public ByteString signByteStrings(ByteString ... bs) throws CryptoException, InvalidArgumentException {
        if (bs == null) {
            return null;
        }
        if (bs.length == 0) {
            return null;
        }
        if (bs.length == 1 && bs[0] == null) {
            return null;
        }
        ByteString f = bs[0];
        for (int i = 1; i < bs.length; ++i) {
            f = f.concat(bs[i]);
        }
        return ByteString.copyFrom((byte[])this.sign(f.toByteArray()));
    }

    public ByteString[] signByteStrings(User[] users, ByteString ... bs) throws CryptoException, InvalidArgumentException {
        if (bs == null) {
            return null;
        }
        if (bs.length == 0) {
            return null;
        }
        if (bs.length == 1 && bs[0] == null) {
            return null;
        }
        ByteString f = bs[0];
        for (int i = 1; i < bs.length; ++i) {
            f = f.concat(bs[i]);
        }
        byte[] signbytes = f.toByteArray();
        ByteString[] ret = new ByteString[users.length];
        int i = -1;
        for (User user : users) {
            SigningIdentity signingIdentity = IdentityFactory.getSigningIdentity(this.cryptoPrimitives, user);
            ret[++i] = ByteString.copyFrom((byte[])signingIdentity.sign(signbytes));
        }
        return ret;
    }

    public String toString() {
        return this.toString;
    }

    public TransactionContext retryTransactionSameContext() {
        return new TransactionContext(this.channel, this.user, this.cryptoPrimitives);
    }

    public Identities.SerializedIdentity getSerializedIdentity() {
        return this.identity;
    }
}

