/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.hyperledger.fabric_ca.sdk.exception.InvalidArgumentException;

public class EnrollmentRequest {
    private String csr;
    private Collection<String> hosts = new ArrayList<String>();
    private String profile = null;
    private String label = null;
    private KeyPair keypair = null;
    private String caName;
    private Map<String, AttrReq> attrreqs = null;

    public void setCsr(String csr) {
        this.csr = csr;
    }

    public EnrollmentRequest() {
    }

    String getCsr() {
        return this.csr;
    }

    public EnrollmentRequest(String profile, String label, KeyPair keypair) {
        this.profile = profile;
        this.label = label;
        this.keypair = keypair;
    }

    KeyPair getKeyPair() {
        return this.keypair;
    }

    public void setKeyPair(KeyPair keypair) {
        this.keypair = keypair;
    }

    void setCSR(String csr) {
        this.csr = csr;
    }

    void setCAName(String caName) {
        this.caName = caName;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Collection<String> getHosts() {
        return new ArrayList<String>(this.hosts);
    }

    public void addHost(String host) {
        this.hosts.add(host);
    }

    String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(stringWriter));
        jsonWriter.writeObject(this.toJsonObject());
        jsonWriter.close();
        return stringWriter.toString();
    }

    private JsonObject toJsonObject() {
        JsonArrayBuilder ab;
        JsonObjectBuilder factory = Json.createObjectBuilder();
        if (this.profile != null) {
            factory.add("profile", this.profile);
        }
        if (!this.hosts.isEmpty()) {
            ab = Json.createArrayBuilder();
            for (String host : this.hosts) {
                ab.add(host);
            }
            factory.add("hosts", (JsonValue)ab.build());
        }
        if (this.label != null) {
            factory.add("label", this.label);
        }
        if (this.caName != null) {
            factory.add("caname", this.caName);
        }
        factory.add("certificate_request", this.csr);
        if (this.attrreqs != null) {
            ab = Json.createArrayBuilder();
            for (AttrReq attrReq : this.attrreqs.values()) {
                JsonObjectBuilder i = Json.createObjectBuilder();
                i.add("name", attrReq.name);
                if (attrReq.optional != null) {
                    i.add("optional", attrReq.optional.booleanValue());
                }
                ab.add(i);
            }
            factory.add("attr_reqs", (JsonValue)ab.build());
        }
        return factory.build();
    }

    public void addAttrReq() throws InvalidArgumentException {
        if (this.attrreqs != null && !this.attrreqs.isEmpty()) {
            throw new InvalidArgumentException("Attributes have already been defined.");
        }
        this.attrreqs = new HashMap<String, AttrReq>();
    }

    public AttrReq addAttrReq(String name) throws InvalidArgumentException {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("name may not be null or empty.");
        }
        return new AttrReq(name);
    }

    public class AttrReq {
        final String name;
        Boolean optional = null;

        AttrReq(String name) {
            this.name = name;
            if (EnrollmentRequest.this.attrreqs == null) {
                EnrollmentRequest.this.attrreqs = new HashMap();
            }
            EnrollmentRequest.this.attrreqs.put(name, this);
        }

        public AttrReq setOptional(boolean optional) {
            this.optional = optional;
            return this;
        }
    }
}

