/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import org.hyperledger.fabric_ca.sdk.HFCAIdentity;
import org.hyperledger.fabric_ca.sdk.exception.AffiliationException;
import org.hyperledger.fabric_ca.sdk.exception.HTTPException;
import org.hyperledger.fabric_ca.sdk.exception.InvalidArgumentException;

public class HFCAAffiliation {
    private String name;
    private String updateName;
    private HFCAClient client;
    private Collection<HFCAAffiliation> childHFCAAffiliations = new ArrayList<HFCAAffiliation>();
    private Collection<HFCAIdentity> identities = new ArrayList<HFCAIdentity>();
    private boolean deleted;
    static final String HFCA_AFFILIATION = "/api/v1/affiliations";
    private static final Log logger = LogFactory.getLog(HFCAAffiliation.class);

    HFCAAffiliation(String name, HFCAClient client) throws InvalidArgumentException {
        this.validateAffiliationNames(name);
        if (client.getCryptoSuite() == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        this.name = name;
        this.client = client;
    }

    HFCAAffiliation(JsonObject result) {
        this.generateResponse(result);
    }

    public String getName() {
        return this.name;
    }

    public String getUpdateName() throws AffiliationException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        return this.updateName;
    }

    public void setUpdateName(String updateName) throws AffiliationException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        this.updateName = updateName;
    }

    public Collection<HFCAAffiliation> getChildren() throws AffiliationException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        return this.childHFCAAffiliations;
    }

    public Collection<HFCAIdentity> getIdentities() throws AffiliationException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        return this.identities;
    }

    public HFCAAffiliation createDecendent(String name) throws InvalidArgumentException, AffiliationException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        this.validateAffiliationNames(name);
        return new HFCAAffiliation(this.name + "." + name, this.client);
    }

    public HFCAAffiliation getChild(String name) throws AffiliationException, InvalidArgumentException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        this.validateSingleAffiliationName(name);
        for (HFCAAffiliation childAff : this.childHFCAAffiliations) {
            if (!childAff.getName().equals(this.name + "." + name)) continue;
            return childAff;
        }
        return null;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int read(User registrar) throws AffiliationException, InvalidArgumentException {
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String readAffURL = "";
        try {
            readAffURL = "/api/v1/affiliations/" + this.name;
            logger.debug((Object)String.format("affiliation  url: %s, registrar: %s", readAffURL, registrar.getName()));
            JsonObject result = this.client.httpGet(readAffURL, registrar);
            logger.debug((Object)String.format("affiliation  url: %s, registrar: %s done.", readAffURL, registrar));
            HFCAAffiliationResp resp = this.getResponse(result);
            this.childHFCAAffiliations = resp.getChildren();
            this.identities = resp.getIdentities();
            this.deleted = false;
            return resp.statusCode;
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while getting affiliation '%s' from url '%s': %s", e.getStatusCode(), this.name, readAffURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
        catch (Exception e) {
            String msg = String.format("Error while getting affiliation %s url: %s  %s ", this.name, readAffURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
    }

    public HFCAAffiliationResp create(User registrar) throws AffiliationException, InvalidArgumentException {
        return this.create(registrar, false);
    }

    public HFCAAffiliationResp create(User registrar, boolean force) throws AffiliationException, InvalidArgumentException {
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String createURL = "";
        try {
            createURL = this.client.getURL(HFCA_AFFILIATION);
            logger.debug((Object)String.format("affiliation  url: %s, registrar: %s", createURL, registrar.getName()));
            HashMap<String, String> queryParm = new HashMap<String, String>();
            queryParm.put("force", String.valueOf(force));
            String body = this.client.toJson(this.affToJsonObject());
            JsonObject result = this.client.httpPost(createURL, body, registrar);
            logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", createURL, registrar));
            this.deleted = false;
            return this.getResponse(result);
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while creating affiliation '%s' from url '%s': %s", e.getStatusCode(), this.name, createURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
        catch (Exception e) {
            String msg = String.format("Error while creating affiliation %s url: %s  %s ", this.name, createURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
    }

    public HFCAAffiliationResp update(User registrar) throws AffiliationException, InvalidArgumentException {
        return this.update(registrar, false);
    }

    public HFCAAffiliationResp update(User registrar, boolean force) throws AffiliationException, InvalidArgumentException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        if (Utils.isNullOrEmpty(this.name)) {
            throw new InvalidArgumentException("Affiliation name cannot be null or empty");
        }
        String updateURL = "";
        try {
            HashMap<String, String> queryParm = new HashMap<String, String>();
            queryParm.put("force", String.valueOf(force));
            updateURL = this.client.getURL("/api/v1/affiliations/" + this.name, queryParm);
            logger.debug((Object)String.format("affiliation  url: %s, registrar: %s", updateURL, registrar.getName()));
            String body = this.client.toJson(this.affToJsonObject());
            JsonObject result = this.client.httpPut(updateURL, body, registrar);
            this.generateResponse(result);
            logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", updateURL, registrar));
            HFCAAffiliationResp resp = this.getResponse(result);
            this.childHFCAAffiliations = resp.childHFCAAffiliations;
            this.identities = resp.identities;
            return this.getResponse(result);
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while updating affiliation '%s' from url '%s': %s", e.getStatusCode(), this.name, updateURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
        catch (Exception e) {
            String msg = String.format("Error while updating affiliation %s url: %s  %s ", this.name, updateURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
    }

    public HFCAAffiliationResp delete(User registrar) throws AffiliationException, InvalidArgumentException {
        return this.delete(registrar, false);
    }

    public HFCAAffiliationResp delete(User registrar, boolean force) throws AffiliationException, InvalidArgumentException {
        if (this.deleted) {
            throw new AffiliationException("Affiliation has been deleted");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String deleteURL = "";
        try {
            HashMap<String, String> queryParm = new HashMap<String, String>();
            queryParm.put("force", String.valueOf(force));
            deleteURL = this.client.getURL("/api/v1/affiliations/" + this.name, queryParm);
            logger.debug((Object)String.format("affiliation  url: %s, registrar: %s", deleteURL, registrar.getName()));
            JsonObject result = this.client.httpDelete(deleteURL, registrar);
            logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", deleteURL, registrar));
            this.deleted = true;
            return this.getResponse(result);
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while deleting affiliation '%s' from url '%s': %s", e.getStatusCode(), this.name, deleteURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
        catch (Exception e) {
            String msg = String.format("Error while deleting affiliation %s url: %s  %s ", this.name, deleteURL, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
    }

    HFCAAffiliationResp getResponse(JsonObject result) {
        if (result.containsKey((Object)"name")) {
            this.name = result.getString("name");
        }
        return new HFCAAffiliationResp(result);
    }

    private void generateResponse(JsonObject result) {
        JsonArray ids;
        int i;
        JsonArray affiliations;
        if (result.containsKey((Object)"name")) {
            this.name = result.getString("name");
        }
        if (result.containsKey((Object)"affiliations") && (affiliations = result.getJsonArray("affiliations")) != null && !affiliations.isEmpty()) {
            for (i = 0; i < affiliations.size(); ++i) {
                JsonObject aff = affiliations.getJsonObject(i);
                this.childHFCAAffiliations.add(new HFCAAffiliation(aff));
            }
        }
        if (result.containsKey((Object)"identities") && (ids = result.getJsonArray("identities")) != null && !ids.isEmpty()) {
            for (i = 0; i < ids.size(); ++i) {
                JsonObject id = ids.getJsonObject(i);
                HFCAIdentity hfcaID = new HFCAIdentity(id);
                this.identities.add(hfcaID);
            }
        }
    }

    private JsonObject affToJsonObject() {
        JsonObjectBuilder ob = Json.createObjectBuilder();
        if (this.client.getCAName() != null) {
            ob.add("caname", this.client.getCAName());
        }
        if (this.updateName != null) {
            ob.add("name", this.updateName);
            this.updateName = null;
        } else {
            ob.add("name", this.name);
        }
        return ob.build();
    }

    void validateAffiliationNames(String name) throws InvalidArgumentException {
        HFCAAffiliation.checkFormat(name);
        if (name.startsWith(".")) {
            throw new InvalidArgumentException("Affiliation name cannot start with a dot '.'");
        }
        if (name.endsWith(".")) {
            throw new InvalidArgumentException("Affiliation name cannot end with a dot '.'");
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '.' || name.charAt(i) != name.charAt(i - 1)) continue;
            throw new InvalidArgumentException("Affiliation name cannot contain multiple consecutive dots '.'");
        }
    }

    void validateSingleAffiliationName(String name) throws InvalidArgumentException {
        HFCAAffiliation.checkFormat(name);
        if (name.contains(".")) {
            throw new InvalidArgumentException("Single affiliation name cannot contain any dots '.'");
        }
    }

    static void checkFormat(String name) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("Affiliation name cannot be null or empty");
        }
        if (name.contains(" ") || name.contains("\t")) {
            throw new InvalidArgumentException("Affiliation name cannot contain an empty space or tab");
        }
    }

    public static class HFCAAffiliationResp {
        private Collection<HFCAAffiliation> childHFCAAffiliations = new ArrayList<HFCAAffiliation>();
        private Collection<HFCAIdentity> identities = new ArrayList<HFCAIdentity>();
        private int statusCode = 200;

        public Collection<HFCAIdentity> getIdentities() {
            return this.identities;
        }

        public Collection<HFCAAffiliation> getChildren() {
            return this.childHFCAAffiliations;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        HFCAAffiliationResp(JsonObject result) {
            JsonArray ids;
            int i;
            JsonArray affiliations;
            if (result.containsKey((Object)"affiliations") && (affiliations = result.getJsonArray("affiliations")) != null && !affiliations.isEmpty()) {
                for (i = 0; i < affiliations.size(); ++i) {
                    JsonObject aff = affiliations.getJsonObject(i);
                    this.childHFCAAffiliations.add(new HFCAAffiliation(aff));
                }
            }
            if (result.containsKey((Object)"identities") && (ids = result.getJsonArray("identities")) != null && !ids.isEmpty()) {
                for (i = 0; i < ids.size(); ++i) {
                    JsonObject id = ids.getJsonObject(i);
                    HFCAIdentity hfcaID = new HFCAIdentity(id);
                    this.identities.add(hfcaID);
                }
            }
            if (result.containsKey((Object)"statusCode")) {
                this.statusCode = result.getInt("statusCode");
            }
        }
    }
}

