/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hyperledger.fabric_ca.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric_ca.sdk.helper.Util;

public class HFCACertificateRequest {
    private final Map<String, String> queryParms = new HashMap<String, String>();

    HFCACertificateRequest() {
    }

    public void setEnrollmentID(String enrollmentID) {
        this.queryParms.put("id", enrollmentID);
    }

    public void setSerial(String serial) {
        this.queryParms.put("serial", serial);
    }

    public void setAki(String aki) {
        this.queryParms.put("aki", aki);
    }

    public void setRevokedStart(Date revokedStart) throws InvalidArgumentException {
        if (revokedStart == null) {
            throw new InvalidArgumentException("Date can't be null");
        }
        this.queryParms.put("revoked_start", Util.dateToString(revokedStart));
    }

    public void setRevokedEnd(Date revokedEnd) throws InvalidArgumentException {
        if (revokedEnd == null) {
            throw new InvalidArgumentException("Date can't be null");
        }
        this.queryParms.put("revoked_end", Util.dateToString(revokedEnd));
    }

    public void setExpiredStart(Date expiredStart) throws InvalidArgumentException {
        if (expiredStart == null) {
            throw new InvalidArgumentException("Date can't be null");
        }
        this.queryParms.put("expired_start", Util.dateToString(expiredStart));
    }

    public void setExpiredEnd(Date expiredEnd) throws InvalidArgumentException {
        if (expiredEnd == null) {
            throw new InvalidArgumentException("Date can't be null");
        }
        this.queryParms.put("expired_end", Util.dateToString(expiredEnd));
    }

    public void setExpired(boolean expired) {
        if (expired) {
            this.queryParms.put("notexpired", "false");
        } else {
            this.queryParms.put("notexpired", "true");
        }
    }

    public void setRevoked(boolean revoked) {
        if (revoked) {
            this.queryParms.put("notrevoked", "false");
        } else {
            this.queryParms.put("notrevoked", "true");
        }
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParms;
    }
}

