/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.milagro.amcl.FP256BN.BIG;
import org.apache.milagro.amcl.RAND;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.io.pem.PemReader;
import org.hyperledger.fabric.protos.idemix.Idemix;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.idemix.IdemixCredRequest;
import org.hyperledger.fabric.sdk.idemix.IdemixCredential;
import org.hyperledger.fabric.sdk.idemix.IdemixIssuerPublicKey;
import org.hyperledger.fabric.sdk.idemix.IdemixUtils;
import org.hyperledger.fabric.sdk.identity.IdemixEnrollment;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;
import org.hyperledger.fabric.sdk.security.CryptoPrimitives;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric_ca.sdk.EnrollmentRequest;
import org.hyperledger.fabric_ca.sdk.HFCAAffiliation;
import org.hyperledger.fabric_ca.sdk.HFCACertificateRequest;
import org.hyperledger.fabric_ca.sdk.HFCACertificateResponse;
import org.hyperledger.fabric_ca.sdk.HFCACredential;
import org.hyperledger.fabric_ca.sdk.HFCAIdentity;
import org.hyperledger.fabric_ca.sdk.HFCAInfo;
import org.hyperledger.fabric_ca.sdk.HFCAX509Certificate;
import org.hyperledger.fabric_ca.sdk.IdemixEnrollmentRequest;
import org.hyperledger.fabric_ca.sdk.RegistrationRequest;
import org.hyperledger.fabric_ca.sdk.RevocationRequest;
import org.hyperledger.fabric_ca.sdk.exception.AffiliationException;
import org.hyperledger.fabric_ca.sdk.exception.EnrollmentException;
import org.hyperledger.fabric_ca.sdk.exception.GenerateCRLException;
import org.hyperledger.fabric_ca.sdk.exception.HFCACertificateException;
import org.hyperledger.fabric_ca.sdk.exception.HTTPException;
import org.hyperledger.fabric_ca.sdk.exception.IdentityException;
import org.hyperledger.fabric_ca.sdk.exception.InfoException;
import org.hyperledger.fabric_ca.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric_ca.sdk.exception.RegistrationException;
import org.hyperledger.fabric_ca.sdk.exception.RevocationException;
import org.hyperledger.fabric_ca.sdk.helper.Config;
import org.hyperledger.fabric_ca.sdk.helper.Util;

public class HFCAClient {
    private static final Config config = Config.getConfig();
    public static final String DEFAULT_PROFILE_NAME = "";
    public static final String HFCA_TYPE_PEER = "peer";
    public static final String HFCA_TYPE_ORDERER = "orderer";
    public static final String HFCA_TYPE_CLIENT = "client";
    public static final String HFCA_TYPE_USER = "user";
    public static final String HFCA_ATTRIBUTE_HFREGISTRARROLES = "hf.Registrar.Roles";
    public static final String HFCA_ATTRIBUTE_HFREGISTRARDELEGATEROLES = "hf.Registrar.DelegateRoles";
    public static final String HFCA_ATTRIBUTE_HFREGISTRARATTRIBUTES = "hf.Registrar.Attributes";
    public static final String HFCA_ATTRIBUTE_HFINTERMEDIATECA = "hf.IntermediateCA";
    public static final String HFCA_ATTRIBUTE_HFREVOKER = "hf.Revoker";
    public static final String HFCA_ATTRIBUTE_HFAFFILIATIONMGR = "hf.AffiliationMgr";
    public static final String HFCA_ATTRIBUTE_HFGENCRL = "hf.GenCRL";
    private static final int CONNECTION_REQUEST_TIMEOUT = config.getConnectionRequestTimeout();
    private static final int CONNECT_TIMEOUT = config.getConnectTimeout();
    private static final int SOCKET_TIMEOUT = config.getSocketTimeout();
    private static final Log logger = LogFactory.getLog(HFCAClient.class);
    static final String FABRIC_CA_REQPROP = "caname";
    static final String HFCA_CONTEXT_ROOT = "/api/v1/";
    private static final String HFCA_ENROLL = "/api/v1/enroll";
    private static final String HFCA_REGISTER = "/api/v1/register";
    private static final String HFCA_REENROLL = "/api/v1/reenroll";
    private static final String HFCA_REVOKE = "/api/v1/revoke";
    private static final String HFCA_INFO = "/api/v1/cainfo";
    private static final String HFCA_GENCRL = "/api/v1/gencrl";
    private static final String HFCA_CERTIFICATE = "/api/v1/certificates";
    private static final String HFCA_IDEMIXCRED = "/api/v1/idemix/credential";
    private final String url;
    private final boolean isSSL;
    private final Properties properties;
    private Boolean newPayloadType;
    private final String caName;
    private CryptoSuite cryptoSuite;
    private int statusCode = 400;
    private Registry<ConnectionSocketFactory> registry = null;
    CryptoPrimitives cryptoPrimitives = null;

    public String getCAName() {
        return this.caName;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    HFCAClient(String caName, String url, Properties properties) throws MalformedURLException {
        logger.debug((Object)String.format("new HFCAClient %s", url));
        this.url = url;
        this.caName = caName;
        URL purl = new URL(url);
        String proto = purl.getProtocol();
        if (!"http".equals(proto) && !"https".equals(proto)) {
            throw new IllegalArgumentException("HFCAClient only supports http or https not " + proto);
        }
        String host = purl.getHost();
        if (Utils.isNullOrEmpty(host)) {
            throw new IllegalArgumentException("HFCAClient url needs host");
        }
        String path = purl.getPath();
        if (!Utils.isNullOrEmpty(path)) {
            throw new IllegalArgumentException("HFCAClient url does not support path portion in url remove path: '" + path + "'.");
        }
        String query = purl.getQuery();
        if (!Utils.isNullOrEmpty(query)) {
            throw new IllegalArgumentException("HFCAClient url does not support query portion in url remove query: '" + query + "'.");
        }
        this.isSSL = "https".equals(proto);
        this.properties = properties != null ? (Properties)properties.clone() : null;
    }

    public static HFCAClient createNewInstance(String url, Properties properties) throws MalformedURLException {
        return new HFCAClient(null, url, properties);
    }

    public static HFCAClient createNewInstance(String name, String url, Properties properties) throws MalformedURLException, InvalidArgumentException {
        if (name == null || name.isEmpty()) {
            throw new InvalidArgumentException("name must not be null or an empty string.");
        }
        return new HFCAClient(name, url, properties);
    }

    public static HFCAClient createNewInstance(NetworkConfig.CAInfo caInfo) throws MalformedURLException, InvalidArgumentException {
        try {
            return HFCAClient.createNewInstance(caInfo, CryptoSuite.Factory.getCryptoSuite());
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
    }

    public static HFCAClient createNewInstance(NetworkConfig.CAInfo caInfo, CryptoSuite cryptoSuite) throws MalformedURLException, InvalidArgumentException {
        if (null == caInfo) {
            throw new InvalidArgumentException("The caInfo parameter can not be null.");
        }
        if (null == cryptoSuite) {
            throw new InvalidArgumentException("The cryptoSuite parameter can not be null.");
        }
        HFCAClient ret = new HFCAClient(caInfo.getCAName(), caInfo.getUrl(), caInfo.getProperties());
        ret.setCryptoSuite(cryptoSuite);
        return ret;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) {
        this.cryptoSuite = cryptoSuite;
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public String register(RegistrationRequest request, User registrar) throws RegistrationException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        if (Utils.isNullOrEmpty(request.getEnrollmentID())) {
            throw new InvalidArgumentException("EntrollmentID cannot be null or empty");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        logger.debug((Object)String.format("register  url: %s, registrar: %s", this.url, registrar.getName()));
        this.setUpSSL();
        try {
            String body = request.toJson();
            JsonObject resp = this.httpPost(this.url + HFCA_REGISTER, body, registrar);
            String secret = resp.getString("secret");
            if (secret == null) {
                throw new Exception("secret was not found in response");
            }
            logger.debug((Object)String.format("register  url: %s, registrar: %s done.", this.url, registrar));
            return secret;
        }
        catch (Exception e) {
            RegistrationException registrationException = new RegistrationException(String.format("Error while registering the user %s url: %s  %s ", registrar, this.url, e.getMessage()), e);
            logger.error((Object)registrar);
            throw registrationException;
        }
    }

    public Enrollment enroll(String user, String secret) throws EnrollmentException, InvalidArgumentException {
        return this.enroll(user, secret, new EnrollmentRequest());
    }

    public Enrollment enroll(String user, String secret, EnrollmentRequest req) throws EnrollmentException, InvalidArgumentException {
        logger.debug((Object)String.format("url:%s enroll user: %s", this.url, user));
        if (Utils.isNullOrEmpty(user)) {
            throw new InvalidArgumentException("enrollment user is not set");
        }
        if (Utils.isNullOrEmpty(secret)) {
            throw new InvalidArgumentException("enrollment secret is not set");
        }
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        this.setUpSSL();
        try {
            String pem = req.getCsr();
            KeyPair keypair = req.getKeyPair();
            if (null != pem && keypair == null) {
                throw new InvalidArgumentException("If certificate signing request is supplied the key pair needs to be supplied too.");
            }
            if (keypair == null) {
                logger.debug((Object)"[HFCAClient.enroll] Generating keys...");
                keypair = this.cryptoSuite.keyGen();
                logger.debug((Object)"[HFCAClient.enroll] Generating keys...done!");
            }
            if (pem == null) {
                String csr = this.cryptoSuite.generateCertificationRequest(user, keypair);
                req.setCSR(csr);
            }
            if (this.caName != null && !this.caName.isEmpty()) {
                req.setCAName(this.caName);
            }
            String body = req.toJson();
            String responseBody = this.httpPost(this.getURL(HFCA_ENROLL), body, new UsernamePasswordCredentials(user, secret));
            logger.debug((Object)("response:" + responseBody));
            JsonReader reader = Json.createReader((Reader)new StringReader(responseBody));
            JsonObject jsonst = (JsonObject)reader.read();
            boolean success = jsonst.getBoolean("success");
            logger.debug((Object)String.format("[HFCAClient] enroll success:[%s]", success));
            if (!success) {
                throw new EnrollmentException(String.format("FabricCA failed enrollment for user %s response success is false.", user));
            }
            JsonObject result = jsonst.getJsonObject("result");
            if (result == null) {
                throw new EnrollmentException(String.format("FabricCA failed enrollment for user %s - response did not contain a result", user));
            }
            Base64.Decoder b64dec = Base64.getDecoder();
            String signedPem = new String(b64dec.decode(result.getString("Cert").getBytes(StandardCharsets.UTF_8)));
            logger.debug((Object)String.format("[HFCAClient] enroll returned pem:[%s]", signedPem));
            JsonArray messages = jsonst.getJsonArray("messages");
            if (messages != null && !messages.isEmpty()) {
                JsonObject jo = messages.getJsonObject(0);
                String message = String.format("Enroll request response message [code %d]: %s", jo.getInt("code"), jo.getString("message"));
                logger.info((Object)message);
            }
            logger.debug((Object)"Enrollment done.");
            return new X509Enrollment(keypair, signedPem);
        }
        catch (EnrollmentException ee) {
            logger.error((Object)String.format("url:%s, user:%s  error:%s", this.url, user, ee.getMessage()), (Throwable)ee);
            throw ee;
        }
        catch (Exception e) {
            EnrollmentException ee = new EnrollmentException(String.format("Url:%s, Failed to enroll user %s ", this.url, user), e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ee;
        }
    }

    public HFCAInfo info() throws InfoException, InvalidArgumentException {
        String infoURL;
        try {
            infoURL = this.getURL(HFCA_INFO);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
        logger.debug((Object)String.format("info url:%s", infoURL));
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        this.setUpSSL();
        try {
            JsonObjectBuilder factory = Json.createObjectBuilder();
            if (this.caName != null) {
                factory.add(FABRIC_CA_REQPROP, this.caName);
            }
            JsonObject body = factory.build();
            String responseBody = this.httpPost(infoURL, body.toString(), (UsernamePasswordCredentials)null);
            logger.debug((Object)("response:" + responseBody));
            JsonReader reader = Json.createReader((Reader)new StringReader(responseBody));
            JsonObject jsonst = (JsonObject)reader.read();
            boolean success = jsonst.getBoolean("success");
            logger.debug((Object)String.format("[HFCAClient] enroll success:[%s]", success));
            if (!success) {
                throw new EnrollmentException(String.format("FabricCA failed info %s", infoURL));
            }
            JsonObject result = jsonst.getJsonObject("result");
            if (result == null) {
                throw new InfoException(String.format("FabricCA info error  - response did not contain a result url %s", infoURL));
            }
            String caName = result.getString("CAName");
            String caChain = result.getString("CAChain");
            String version = null;
            if (result.containsKey((Object)"Version")) {
                version = result.getString("Version");
            }
            String issuerPublicKey = null;
            if (result.containsKey((Object)"IssuerPublicKey")) {
                issuerPublicKey = result.getString("IssuerPublicKey");
            }
            String issuerRevocationPublicKey = null;
            if (result.containsKey((Object)"IssuerRevocationPublicKey")) {
                issuerRevocationPublicKey = result.getString("IssuerRevocationPublicKey");
            }
            logger.info((Object)String.format("CA Name: %s, Version: %s, issuerPublicKey: %s, issuerRevocationPublicKey: %s", caName, caChain, issuerPublicKey, issuerRevocationPublicKey));
            return new HFCAInfo(caName, caChain, version, issuerPublicKey, issuerRevocationPublicKey);
        }
        catch (Exception e) {
            InfoException ee = new InfoException(String.format("Url:%s, Failed to get info", infoURL), e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ee;
        }
    }

    public Enrollment reenroll(User user) throws EnrollmentException, InvalidArgumentException {
        return this.reenroll(user, new EnrollmentRequest());
    }

    public Enrollment reenroll(User user, EnrollmentRequest req) throws EnrollmentException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        if (user == null) {
            throw new InvalidArgumentException("reenrollment user is missing");
        }
        if (user.getEnrollment() == null) {
            throw new InvalidArgumentException("reenrollment user is not a valid user object");
        }
        logger.debug((Object)String.format("re-enroll user: %s, url: %s", user.getName(), this.url));
        try {
            this.setUpSSL();
            PublicKey publicKey = this.cryptoSuite.bytesToCertificate(user.getEnrollment().getCert().getBytes(StandardCharsets.UTF_8)).getPublicKey();
            KeyPair keypair = new KeyPair(publicKey, user.getEnrollment().getKey());
            String pem = this.cryptoSuite.generateCertificationRequest(user.getName(), keypair);
            req.setCSR(pem);
            if (this.caName != null && !this.caName.isEmpty()) {
                req.setCAName(this.caName);
            }
            String body = req.toJson();
            JsonObject result = this.httpPost(this.url + HFCA_REENROLL, body, user);
            Base64.Decoder b64dec = Base64.getDecoder();
            String signedPem = new String(b64dec.decode(result.getString("Cert").getBytes(StandardCharsets.UTF_8)));
            logger.debug((Object)String.format("[HFCAClient] re-enroll returned pem:[%s]", signedPem));
            logger.debug((Object)String.format("reenroll user %s done.", user.getName()));
            return new X509Enrollment(keypair, signedPem);
        }
        catch (EnrollmentException ee) {
            logger.error((Object)ee.getMessage(), (Throwable)ee);
            throw ee;
        }
        catch (Exception e) {
            EnrollmentException ee = new EnrollmentException(String.format("Failed to re-enroll user %s", user), e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ee;
        }
    }

    public void revoke(User revoker, Enrollment enrollment, String reason) throws RevocationException, InvalidArgumentException {
        this.revokeInternal(revoker, enrollment, reason, false);
    }

    public String revoke(User revoker, Enrollment enrollment, String reason, boolean genCRL) throws RevocationException, InvalidArgumentException {
        return this.revokeInternal(revoker, enrollment, reason, genCRL);
    }

    private String revokeInternal(User revoker, Enrollment enrollment, String reason, boolean genCRL) throws RevocationException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        if (enrollment == null) {
            throw new InvalidArgumentException("revokee enrollment is not set");
        }
        if (revoker == null) {
            throw new InvalidArgumentException("revoker is not set");
        }
        logger.debug((Object)String.format("revoke revoker: %s, reason: %s, url: %s", revoker.getName(), reason, this.url));
        try {
            this.setUpSSL();
            BufferedInputStream pem = new BufferedInputStream(new ByteArrayInputStream(enrollment.getCert().getBytes()));
            CertificateFactory certFactory = CertificateFactory.getInstance(Config.getConfig().getCertificateFormat());
            X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(pem);
            String serial = DatatypeConverter.printHexBinary((byte[])certificate.getSerialNumber().toByteArray());
            byte[] extensionValue = certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            ASN1OctetString akiOc = ASN1OctetString.getInstance((Object)extensionValue);
            String aki = DatatypeConverter.printHexBinary((byte[])AuthorityKeyIdentifier.getInstance((Object)akiOc.getOctets()).getKeyIdentifier());
            RevocationRequest req = new RevocationRequest(this.caName, null, serial, aki, reason, genCRL);
            String body = req.toJson();
            JsonObject resp = this.httpPost(this.url + HFCA_REVOKE, body, revoker);
            logger.debug((Object)"revoke done");
            if (genCRL) {
                if (resp.isEmpty()) {
                    throw new RevocationException("Failed to return CRL, revoke response is empty");
                }
                if (resp.isNull("CRL")) {
                    throw new RevocationException("Failed to return CRL");
                }
                return resp.getString("CRL");
            }
            return null;
        }
        catch (CertificateException e) {
            logger.error((Object)("Cannot validate certificate. Error is: " + e.getMessage()));
            throw new RevocationException("Error while revoking cert. " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RevocationException("Error while revoking the user. " + e.getMessage(), e);
        }
    }

    public void revoke(User revoker, String revokee, String reason) throws RevocationException, InvalidArgumentException {
        this.revokeInternal(revoker, revokee, reason, false);
    }

    public String revoke(User revoker, String revokee, String reason, boolean genCRL) throws RevocationException, InvalidArgumentException {
        return this.revokeInternal(revoker, revokee, reason, genCRL);
    }

    private String revokeInternal(User revoker, String revokee, String reason, boolean genCRL) throws RevocationException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        logger.debug((Object)String.format("revoke revoker: %s, revokee: %s, reason: %s", revoker, revokee, reason));
        if (Utils.isNullOrEmpty(revokee)) {
            throw new InvalidArgumentException("revokee user is not set");
        }
        if (revoker == null) {
            throw new InvalidArgumentException("revoker is not set");
        }
        try {
            this.setUpSSL();
            RevocationRequest req = new RevocationRequest(this.caName, revokee, null, null, reason, genCRL);
            String body = req.toJson();
            JsonObject resp = this.httpPost(this.url + HFCA_REVOKE, body, revoker);
            logger.debug((Object)String.format("revoke revokee: %s done.", revokee));
            if (genCRL) {
                if (resp.isEmpty()) {
                    throw new RevocationException("Failed to return CRL, revoke response is empty");
                }
                if (resp.isNull("CRL")) {
                    throw new RevocationException("Failed to return CRL");
                }
                return resp.getString("CRL");
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RevocationException("Error while revoking the user. " + e.getMessage(), e);
        }
    }

    public void revoke(User revoker, String serial, String aki, String reason) throws RevocationException, InvalidArgumentException {
        this.revokeInternal(revoker, serial, aki, reason, false);
    }

    public String revoke(User revoker, String serial, String aki, String reason, boolean genCRL) throws RevocationException, InvalidArgumentException {
        return this.revokeInternal(revoker, serial, aki, reason, genCRL);
    }

    private String revokeInternal(User revoker, String serial, String aki, String reason, boolean genCRL) throws RevocationException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        if (Utils.isNullOrEmpty(serial)) {
            throw new IllegalArgumentException("Serial number id required to revoke ceritificate");
        }
        if (Utils.isNullOrEmpty(aki)) {
            throw new IllegalArgumentException("AKI is required to revoke certificate");
        }
        if (revoker == null) {
            throw new InvalidArgumentException("revoker is not set");
        }
        logger.debug((Object)String.format("revoke revoker: %s, reason: %s, url: %s", revoker.getName(), reason, this.url));
        try {
            this.setUpSSL();
            RevocationRequest req = new RevocationRequest(this.caName, null, serial, aki, reason, genCRL);
            String body = req.toJson();
            JsonObject resp = this.httpPost(this.url + HFCA_REVOKE, body, revoker);
            logger.debug((Object)"revoke done");
            if (genCRL) {
                if (resp.isEmpty()) {
                    throw new RevocationException("Failed to return CRL, revoke response is empty");
                }
                if (resp.isNull("CRL")) {
                    throw new RevocationException("Failed to return CRL");
                }
                return resp.getString("CRL");
            }
            return null;
        }
        catch (CertificateException e) {
            logger.error((Object)("Cannot validate certificate. Error is: " + e.getMessage()));
            throw new RevocationException("Error while revoking cert. " + e.getMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RevocationException("Error while revoking the user. " + e.getMessage(), e);
        }
    }

    public String generateCRL(User registrar, Date revokedBefore, Date revokedAfter, Date expireBefore, Date expireAfter) throws InvalidArgumentException, GenerateCRLException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("registrar is not set");
        }
        try {
            this.setUpSSL();
            JsonObjectBuilder factory = Json.createObjectBuilder();
            if (revokedBefore != null) {
                factory.add("revokedBefore", Util.dateToString(revokedBefore));
            }
            if (revokedAfter != null) {
                factory.add("revokedAfter", Util.dateToString(revokedAfter));
            }
            if (expireBefore != null) {
                factory.add("expireBefore", Util.dateToString(expireBefore));
            }
            if (expireAfter != null) {
                factory.add("expireAfter", Util.dateToString(expireAfter));
            }
            if (this.caName != null) {
                factory.add(FABRIC_CA_REQPROP, this.caName);
            }
            JsonObject jsonObject = factory.build();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(stringWriter));
            jsonWriter.writeObject(jsonObject);
            jsonWriter.close();
            String body = stringWriter.toString();
            JsonObject ret = this.httpPost(this.url + HFCA_GENCRL, body, registrar);
            return ret.getString("CRL");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GenerateCRLException(e.getMessage(), e);
        }
    }

    public HFCAIdentity newHFCAIdentity(String enrollmentID) throws InvalidArgumentException {
        return new HFCAIdentity(enrollmentID, this);
    }

    public Collection<HFCAIdentity> getHFCAIdentities(User registrar) throws IdentityException, InvalidArgumentException {
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        logger.debug((Object)String.format("identity  url: %s, registrar: %s", this.url, registrar.getName()));
        try {
            JsonObject result = this.httpGet("/api/v1/identities", registrar);
            ArrayList<HFCAIdentity> allIdentities = new ArrayList<HFCAIdentity>();
            JsonArray identities = result.getJsonArray("identities");
            if (identities != null && !identities.isEmpty()) {
                for (int i = 0; i < identities.size(); ++i) {
                    JsonObject identity = identities.getJsonObject(i);
                    HFCAIdentity idObj = new HFCAIdentity(identity);
                    allIdentities.add(idObj);
                }
            }
            logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", this.url, registrar));
            return allIdentities;
        }
        catch (HTTPException e) {
            String msg = String.format("[HTTP Status Code: %d] - Error while getting all users from url '%s': %s", e.getStatusCode(), this.url, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
        catch (Exception e) {
            String msg = String.format("Error while getting all users from url '%s': %s", this.url, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
    }

    public HFCAAffiliation newHFCAAffiliation(String name) throws InvalidArgumentException {
        return new HFCAAffiliation(name, this);
    }

    public HFCAAffiliation getHFCAAffiliations(User registrar) throws AffiliationException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set.");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        logger.debug((Object)String.format("affiliations  url: %s, registrar: %s", this.url, registrar.getName()));
        try {
            JsonObject result = this.httpGet("/api/v1/affiliations", registrar);
            HFCAAffiliation affiliations = new HFCAAffiliation(result);
            logger.debug((Object)String.format("affiliations  url: %s, registrar: %s done.", this.url, registrar));
            return affiliations;
        }
        catch (HTTPException e) {
            String msg = String.format("[HTTP Status Code: %d] - Error while getting all affiliations from url '%s': %s", e.getStatusCode(), this.url, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
        catch (Exception e) {
            String msg = String.format("Error while getting all affiliations from url '%s': %s", this.url, e.getMessage());
            AffiliationException affiliationException = new AffiliationException(msg, e);
            logger.error((Object)msg);
            throw affiliationException;
        }
    }

    public HFCACertificateRequest newHFCACertificateRequest() {
        return new HFCACertificateRequest();
    }

    public Enrollment idemixEnroll(Enrollment enrollment, String mspID) throws EnrollmentException, InvalidArgumentException {
        if (this.cryptoSuite == null) {
            throw new InvalidArgumentException("Crypto primitives not set");
        }
        if (enrollment == null) {
            throw new InvalidArgumentException("enrollment is missing");
        }
        if (Utils.isNullOrEmpty(mspID)) {
            throw new InvalidArgumentException("mspID cannot be null or empty");
        }
        if (enrollment instanceof IdemixEnrollment) {
            throw new InvalidArgumentException("enrollment type must be x509");
        }
        RAND rng = IdemixUtils.getRand();
        try {
            this.setUpSSL();
            IdemixEnrollmentRequest idemixEnrollReq = new IdemixEnrollmentRequest();
            String body = idemixEnrollReq.toJson();
            JsonObject result = this.httpPost(this.url + HFCA_IDEMIXCRED, body, enrollment);
            if (result == null) {
                throw new EnrollmentException("No response received for idemix enrollment request");
            }
            String nonceString = result.getString("Nonce");
            if (Utils.isNullOrEmpty(nonceString)) {
                throw new InvalidArgumentException("fabric-ca-server did not return a nonce in the response from /api/v1/idemix/credential");
            }
            byte[] nonceBytes = Base64.getDecoder().decode(nonceString.getBytes());
            BIG nonce = BIG.fromBytes((byte[])nonceBytes);
            JsonObject info = result.getJsonObject("CAInfo");
            if (info == null) {
                throw new Exception("fabric-ca-server did not return 'cainfo' in the response from /api/v1/idemix/credential");
            }
            IdemixIssuerPublicKey ipk = this.getIssuerPublicKey(info.getString("IssuerPublicKey"));
            PublicKey rpk = this.getRevocationPublicKey(info.getString("IssuerRevocationPublicKey"));
            BIG sk = new BIG(IdemixUtils.randModOrder(rng));
            IdemixCredRequest idemixCredRequest = new IdemixCredRequest(sk, nonce, ipk);
            idemixEnrollReq.setIdemixCredReq(idemixCredRequest);
            body = idemixEnrollReq.toJson();
            result = this.httpPost(this.url + HFCA_IDEMIXCRED, body, enrollment);
            if (result == null) {
                throw new EnrollmentException("No response received for idemix enrollment request");
            }
            String credential = result.getString("Credential");
            if (Utils.isNullOrEmpty(credential)) {
                throw new InvalidArgumentException("fabric-ca-server did not return a 'credential' in the response from /api/v1/idemix/credential");
            }
            byte[] credBytes = Base64.getDecoder().decode(credential.getBytes(StandardCharsets.UTF_8));
            Idemix.Credential credProto = Idemix.Credential.parseFrom(credBytes);
            IdemixCredential cred = new IdemixCredential(credProto);
            String criStr = result.getString("CRI");
            if (Utils.isNullOrEmpty(criStr)) {
                throw new InvalidArgumentException("fabric-ca-server did not return a 'CRI' in the response from /api/v1/idemix/credential");
            }
            byte[] criBytes = Base64.getDecoder().decode(criStr.getBytes(StandardCharsets.UTF_8));
            Idemix.CredentialRevocationInformation cri = Idemix.CredentialRevocationInformation.parseFrom(criBytes);
            JsonObject attrs = result.getJsonObject("Attrs");
            if (attrs == null) {
                throw new EnrollmentException("fabric-ca-server did not return 'attrs' in the response from /api/v1/idemix/credential");
            }
            String ou = attrs.getString("OU");
            if (Utils.isNullOrEmpty(ou)) {
                throw new InvalidArgumentException("fabric-ca-server did not return a 'ou' attribute in the response from /api/v1/idemix/credential");
            }
            int role = attrs.getInt("Role");
            return new IdemixEnrollment(ipk, rpk, mspID, sk, cred, cri, ou, role);
        }
        catch (EnrollmentException ee) {
            logger.error((Object)ee.getMessage(), (Throwable)ee);
            throw ee;
        }
        catch (Exception e) {
            EnrollmentException ee = new EnrollmentException("Failed to get Idemix credential", e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ee;
        }
    }

    private IdemixIssuerPublicKey getIssuerPublicKey(String str) throws EnrollmentException, InvalidProtocolBufferException {
        if (Utils.isNullOrEmpty(str)) {
            throw new EnrollmentException("fabric-ca-server did not return 'issuerPublicKey' in the response from /api/v1/idemix/credential");
        }
        byte[] ipkBytes = Base64.getDecoder().decode(str.getBytes());
        Idemix.IssuerPublicKey ipkProto = Idemix.IssuerPublicKey.parseFrom(ipkBytes);
        return new IdemixIssuerPublicKey(ipkProto);
    }

    private PublicKey getRevocationPublicKey(String str) throws EnrollmentException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (Utils.isNullOrEmpty(str)) {
            throw new EnrollmentException("fabric-ca-server did not return 'issuerPublicKey' in the response from /api/v1/idemix/credential");
        }
        String pem = new String(Base64.getDecoder().decode(str));
        byte[] der = this.convertPemToDer(pem);
        return KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(der));
    }

    private byte[] convertPemToDer(String pem) throws IOException {
        PemReader pemReader = new PemReader((Reader)new StringReader(pem));
        return pemReader.readPemObject().getContent();
    }

    public HFCACertificateResponse getHFCACertificates(User registrar, HFCACertificateRequest req) throws HFCACertificateException {
        try {
            logger.debug((Object)String.format("certificate url: %s, registrar: %s", HFCA_CERTIFICATE, registrar.getName()));
            JsonObject result = this.httpGet(HFCA_CERTIFICATE, registrar, req.getQueryParameters());
            int statusCode = result.getInt("statusCode");
            ArrayList<HFCACredential> certs = new ArrayList<HFCACredential>();
            if (statusCode < 400) {
                JsonArray certificates = result.getJsonArray("certs");
                if (certificates != null && !certificates.isEmpty()) {
                    for (int i = 0; i < certificates.size(); ++i) {
                        String certPEM = certificates.getJsonObject(i).getString("PEM");
                        certs.add(new HFCAX509Certificate(certPEM));
                    }
                }
                logger.debug((Object)String.format("certificate url: %s, registrar: %s done.", HFCA_CERTIFICATE, registrar));
            }
            return new HFCACertificateResponse(statusCode, certs);
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while getting certificates from url '%s': %s", e.getStatusCode(), HFCA_CERTIFICATE, e.getMessage());
            HFCACertificateException certificateException = new HFCACertificateException(msg, e);
            logger.error((Object)msg);
            throw certificateException;
        }
        catch (Exception e) {
            String msg = String.format("Error while getting certificates from url '%s': %s", HFCA_CERTIFICATE, e.getMessage());
            HFCACertificateException certificateException = new HFCACertificateException(msg, e);
            logger.error((Object)msg);
            throw certificateException;
        }
    }

    String httpPost(String url, String body, UsernamePasswordCredentials credentials) throws Exception {
        logger.debug((Object)String.format("httpPost %s, body:%s", url, body));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        BasicCredentialsProvider provider = null;
        if (credentials != null) {
            provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        if (this.registry != null) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry));
        }
        CloseableHttpClient client = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(this.getRequestConfig());
        BasicAuthCache authCache = new BasicAuthCache();
        HttpHost targetHost = new HttpHost(httpPost.getURI().getHost(), httpPost.getURI().getPort());
        if (credentials != null) {
            authCache.put(targetHost, (AuthScheme)new BasicScheme());
        }
        HttpClientContext context = HttpClientContext.create();
        if (null != provider) {
            context.setCredentialsProvider((CredentialsProvider)provider);
        }
        if (credentials != null) {
            context.setAuthCache((AuthCache)authCache);
        }
        httpPost.setEntity((HttpEntity)new StringEntity(body));
        if (credentials != null) {
            httpPost.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)httpPost, (HttpContext)context));
        }
        HttpResponse response = client.execute((HttpUriRequest)httpPost, (HttpContext)context);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        logger.trace((Object)String.format("httpPost %s  sending...", url));
        String responseBody = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        logger.trace((Object)String.format("httpPost %s  responseBody %s", url, responseBody));
        if (status >= 400) {
            Exception e = new Exception(String.format("POST request to %s  with request body: %s, failed with status code: %d. Response: %s", url, body, status, responseBody));
            logger.error((Object)e.getMessage());
            throw e;
        }
        logger.debug((Object)String.format("httpPost Status: %d returning: %s ", status, responseBody));
        return responseBody;
    }

    JsonObject httpPost(String url, String body, User registrar) throws Exception {
        String authHTTPCert = this.getHTTPAuthCertificate(registrar.getEnrollment(), "POST", url, body);
        return this.post(url, body, authHTTPCert);
    }

    JsonObject httpPost(String url, String body, Enrollment enrollment) throws Exception {
        String authHTTPCert = this.getHTTPAuthCertificate(enrollment, "POST", url, body);
        return this.post(url, body, authHTTPCert);
    }

    JsonObject post(String url, String body, String authHTTPCert) throws Exception {
        url = this.addCAToURL(url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(this.getRequestConfig());
        logger.debug((Object)String.format("httpPost %s, body:%s, authHTTPCert: %s", url, body, authHTTPCert));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.registry != null) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry));
        }
        CloseableHttpClient client = httpClientBuilder.build();
        HttpClientContext context = HttpClientContext.create();
        httpPost.setEntity((HttpEntity)new StringEntity(body));
        httpPost.addHeader("Authorization", authHTTPCert);
        HttpResponse response = client.execute((HttpUriRequest)httpPost, (HttpContext)context);
        return this.getResult(response, body, "POST");
    }

    JsonObject httpGet(String url, User registrar) throws Exception {
        return this.httpGet(url, registrar, null);
    }

    JsonObject httpGet(String url, User registrar, Map<String, String> queryMap) throws Exception {
        String getURL = this.getURL(url, queryMap);
        String authHTTPCert = this.getHTTPAuthCertificate(registrar.getEnrollment(), "GET", getURL, DEFAULT_PROFILE_NAME);
        HttpGet httpGet = new HttpGet(getURL);
        httpGet.setConfig(this.getRequestConfig());
        logger.debug((Object)String.format("httpGet %s, authHTTPCert: %s", url, authHTTPCert));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.registry != null) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry));
        }
        CloseableHttpClient client = httpClientBuilder.build();
        HttpClientContext context = HttpClientContext.create();
        httpGet.addHeader("Authorization", authHTTPCert);
        HttpResponse response = client.execute((HttpUriRequest)httpGet, (HttpContext)context);
        return this.getResult(response, DEFAULT_PROFILE_NAME, "GET");
    }

    JsonObject httpPut(String url, String body, User registrar) throws Exception {
        String authHTTPCert = this.getHTTPAuthCertificate(registrar.getEnrollment(), "PUT", url, body);
        String putURL = this.addCAToURL(url);
        HttpPut httpPut = new HttpPut(putURL);
        httpPut.setConfig(this.getRequestConfig());
        logger.debug((Object)String.format("httpPutt %s, body:%s, authHTTPCert: %s", url, body, authHTTPCert));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.registry != null) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry));
        }
        CloseableHttpClient client = httpClientBuilder.build();
        HttpClientContext context = HttpClientContext.create();
        httpPut.setEntity((HttpEntity)new StringEntity(body));
        httpPut.addHeader("Authorization", authHTTPCert);
        HttpResponse response = client.execute((HttpUriRequest)httpPut, (HttpContext)context);
        return this.getResult(response, body, "PUT");
    }

    JsonObject httpDelete(String url, User registrar) throws Exception {
        String authHTTPCert = this.getHTTPAuthCertificate(registrar.getEnrollment(), "DELETE", url, DEFAULT_PROFILE_NAME);
        String deleteURL = this.addCAToURL(url);
        HttpDelete httpDelete = new HttpDelete(deleteURL);
        httpDelete.setConfig(this.getRequestConfig());
        logger.debug((Object)String.format("httpPut %s, authHTTPCert: %s", url, authHTTPCert));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.registry != null) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(this.registry));
        }
        CloseableHttpClient client = httpClientBuilder.build();
        HttpClientContext context = HttpClientContext.create();
        httpDelete.addHeader("Authorization", authHTTPCert);
        HttpResponse response = client.execute((HttpUriRequest)httpDelete, (HttpContext)context);
        return this.getResult(response, DEFAULT_PROFILE_NAME, "DELETE");
    }

    JsonObject getResult(HttpResponse response, String body, String type) throws HTTPException, ParseException, IOException {
        int respStatusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        logger.trace((Object)String.format("response status %d, HttpEntity %s ", respStatusCode, DEFAULT_PROFILE_NAME + entity));
        String responseBody = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        logger.trace((Object)String.format("responseBody: %s ", responseBody));
        if (respStatusCode >= this.statusCode) {
            HTTPException e = new HTTPException(String.format("%s request to %s failed request body %s. Response: %s", type, this.url, body, responseBody), respStatusCode);
            logger.error((Object)e.getMessage());
            throw e;
        }
        if (responseBody == null) {
            HTTPException e = new HTTPException(String.format("%s request to %s failed request body %s with null response body returned.", type, this.url, body), respStatusCode);
            logger.error((Object)e.getMessage());
            throw e;
        }
        logger.debug((Object)("Status: " + respStatusCode));
        JsonReader reader = Json.createReader((Reader)new StringReader(responseBody));
        JsonObject jobj = (JsonObject)reader.read();
        JsonObjectBuilder job = Json.createObjectBuilder();
        job.add("statusCode", respStatusCode);
        JsonArray errors = jobj.getJsonArray("errors");
        if (respStatusCode < this.statusCode && respStatusCode >= 400) {
            if (errors != null && !errors.isEmpty()) {
                JsonObject jo = errors.getJsonObject(0);
                String errorMsg = String.format("[HTTP Status Code: %d] - %s request to %s failed request body %s error message: [Error Code %d] - %s", respStatusCode, type, this.url, body, jo.getInt("code"), jo.getString("message"));
                logger.error((Object)errorMsg);
            }
            return job.build();
        }
        if (errors != null && !errors.isEmpty()) {
            JsonObject jo = errors.getJsonObject(0);
            HTTPException e = new HTTPException(String.format("%s request to %s failed request body %s error message: [Error Code %d] - %s", type, this.url, body, jo.getInt("code"), jo.getString("message")), respStatusCode);
            throw e;
        }
        boolean success = jobj.getBoolean("success");
        if (!success) {
            HTTPException e = new HTTPException(String.format("%s request to %s failed request body %s Body of response did not contain success", type, this.url, body), respStatusCode);
            logger.error((Object)e.getMessage());
            throw e;
        }
        JsonObject result = jobj.getJsonObject("result");
        if (result == null) {
            HTTPException e = new HTTPException(String.format("%s request to %s failed request body %s Body of response did not contain result", type, this.url, body), respStatusCode);
            logger.error((Object)e.getMessage());
            throw e;
        }
        JsonArray messages = jobj.getJsonArray("messages");
        if (messages != null && !messages.isEmpty()) {
            JsonObject jo = messages.getJsonObject(0);
            String message = String.format("%s request to %s failed request body %s response message: [Error Code %d] - %s", type, this.url, body, jo.getInt("code"), jo.getString("message"));
            logger.info((Object)message);
        }
        for (Map.Entry entry : result.entrySet()) {
            job.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        job.add("statusCode", respStatusCode);
        result = job.build();
        logger.debug((Object)String.format("%s %s, body:%s result: %s", type, this.url, body, DEFAULT_PROFILE_NAME + result));
        return result;
    }

    String getHTTPAuthCertificate(Enrollment enrollment, String method, String url, String body) throws Exception {
        String signString;
        Base64.Encoder b64 = Base64.getEncoder();
        String cert = b64.encodeToString(enrollment.getCert().getBytes(StandardCharsets.UTF_8));
        body = b64.encodeToString(body.getBytes(StandardCharsets.UTF_8));
        if (this.newPayloadType == null) {
            String version;
            this.newPayloadType = true;
            String caVersion = this.info().getVersion();
            logger.info((Object)String.format("CA Version: %s", caVersion));
            if (Utils.isNullOrEmpty(caVersion)) {
                this.newPayloadType = false;
            }
            if ((version = caVersion + ".").startsWith("1.1.") || version.startsWith("1.2.") || version.startsWith("1.3.")) {
                this.newPayloadType = false;
            }
        }
        if (this.newPayloadType.booleanValue()) {
            url = this.addCAToURL(url);
            String file = b64.encodeToString(new URL(url).getFile().getBytes(StandardCharsets.UTF_8));
            signString = method + "." + file + "." + body + "." + cert;
        } else {
            signString = body + "." + cert;
        }
        byte[] signature = this.cryptoSuite.sign(enrollment.getKey(), signString.getBytes(StandardCharsets.UTF_8));
        return cert + "." + b64.encodeToString(signature);
    }

    private void setUpSSL() throws InvalidArgumentException {
        if (this.cryptoPrimitives == null) {
            try {
                this.cryptoPrimitives = new CryptoPrimitives();
                this.cryptoPrimitives.init();
            }
            catch (Exception e) {
                throw new InvalidArgumentException(e);
            }
        }
        if (this.isSSL && null == this.registry) {
            if (!this.properties.containsKey("pemBytes") && !this.properties.containsKey("pemFile")) {
                logger.warn((Object)"SSL with no CA certficates in either pemBytes or pemFile");
            }
            try {
                String pemFile;
                if (this.properties.containsKey("pemBytes")) {
                    byte[] permbytes = (byte[])this.properties.get("pemBytes");
                    BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(permbytes));
                    Object object = null;
                    try {
                        this.cryptoPrimitives.addCACertificatesToTrustStore(bis);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (bis != null) {
                            if (object != null) {
                                try {
                                    bis.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                bis.close();
                            }
                        }
                    }
                }
                if (this.properties.containsKey("pemFile") && (pemFile = this.properties.getProperty("pemFile")) != null) {
                    String[] pems = pemFile.split("[ \t]*,[ \t]*");
                    for (String pem : pems) {
                        if (null == pem || pem.isEmpty()) continue;
                        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(Files.readAllBytes(Paths.get(pem, new String[0]))));){
                            this.cryptoPrimitives.addCACertificatesToTrustStore(bis);
                        }
                        catch (IOException e) {
                            throw new InvalidArgumentException(String.format("Unable to add CA certificate, can't open certificate file %s", new File(pem).getAbsolutePath()));
                        }
                    }
                }
                String tlsClientKeyFile = this.properties.getProperty("tlsClientKeyFile");
                String tlsClientCertFile = this.properties.getProperty("tlsClientCertFile");
                byte[] tlsClientKeyAsBytes = (byte[])this.properties.get("tlsClientKeyBytes");
                if (tlsClientKeyFile != null && tlsClientKeyAsBytes != null) {
                    logger.warn((Object)"SSL CA client key is specified as bytes and as a file path. Using client key specified as bytes.");
                }
                if (tlsClientKeyFile != null && tlsClientKeyAsBytes == null) {
                    tlsClientKeyAsBytes = Files.readAllBytes(Paths.get(tlsClientKeyFile, new String[0]));
                }
                byte[] tlsClientCertAsBytes = (byte[])this.properties.get("tlsClientCertBytes");
                if (tlsClientCertFile != null && tlsClientCertAsBytes != null) {
                    logger.warn((Object)"SSL CA client cert is specified as bytes and as a file path. Using client cert specified as bytes.");
                }
                if (tlsClientCertFile != null && tlsClientCertAsBytes == null) {
                    tlsClientCertAsBytes = Files.readAllBytes(Paths.get(tlsClientCertFile, new String[0]));
                }
                if (tlsClientKeyAsBytes != null && tlsClientCertAsBytes != null) {
                    this.cryptoPrimitives.addClientCACertificateToTrustStore(tlsClientKeyAsBytes, tlsClientCertAsBytes, null);
                }
                SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(this.cryptoPrimitives.getTrustStore(), new char[0]).loadTrustMaterial(this.cryptoPrimitives.getTrustStore(), null).build();
                SSLConnectionSocketFactory sslSocketFactory = this.properties != null && Boolean.parseBoolean(this.properties.getProperty("allowAllHostNames")) ? new SSLConnectionSocketFactory(sslContext, (hostname, session) -> true) : new SSLConnectionSocketFactory(sslContext);
                this.registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new InvalidArgumentException(e);
            }
        }
    }

    String getURL(String endpoint) throws URISyntaxException, MalformedURLException, InvalidArgumentException {
        return this.getURL(endpoint, null);
    }

    String getURL(String endpoint, Map<String, String> queryMap) throws URISyntaxException, MalformedURLException, InvalidArgumentException {
        this.setUpSSL();
        String url = this.addCAToURL(this.url + endpoint);
        URIBuilder uri = new URIBuilder(url);
        if (queryMap != null) {
            for (Map.Entry<String, String> param : queryMap.entrySet()) {
                if (Utils.isNullOrEmpty(param.getValue())) continue;
                uri.addParameter(param.getKey(), param.getValue());
            }
        }
        return uri.build().toURL().toString();
    }

    String addCAToURL(String url) throws URISyntaxException, MalformedURLException {
        URIBuilder uri = new URIBuilder(url);
        if (this.caName != null) {
            boolean found = false;
            for (NameValuePair nameValuePair : uri.getQueryParams()) {
                if (!"ca".equals(nameValuePair.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                uri.addParameter("ca", this.caName);
            }
        }
        return uri.build().toURL().toString();
    }

    String toJson(JsonObject toJsonFunc) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(stringWriter));
        jsonWriter.writeObject(toJsonFunc);
        jsonWriter.close();
        return stringWriter.toString();
    }

    private RequestConfig getRequestConfig() {
        RequestConfig.Builder ret = RequestConfig.custom();
        ret.setConnectionRequestTimeout(CONNECTION_REQUEST_TIMEOUT);
        ret.setConnectTimeout(CONNECT_TIMEOUT);
        ret.setSocketTimeout(SOCKET_TIMEOUT);
        return ret.build();
    }

    private class AllHostsSSLSocketFactory
    extends SSLSocketFactory {
        final SSLContext sslContext;

        AllHostsSSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super(truststore);
            this.sslContext = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }

        public Socket createSocket() throws IOException {
            return this.sslContext.getSocketFactory().createSocket();
        }
    }
}

