/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric_ca.sdk.Attribute;
import org.hyperledger.fabric_ca.sdk.HFCAAffiliation;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import org.hyperledger.fabric_ca.sdk.exception.HTTPException;
import org.hyperledger.fabric_ca.sdk.exception.IdentityException;
import org.hyperledger.fabric_ca.sdk.exception.InvalidArgumentException;

public class HFCAIdentity {
    private final String enrollmentID;
    private String type = "user";
    private String secret;
    private Integer maxEnrollments = null;
    private String affiliation;
    private Collection<Attribute> attrs = new ArrayList<Attribute>();
    private HFCAClient client;
    private int statusCode;
    private boolean deleted;
    static final String HFCA_IDENTITY = "/api/v1/identities";
    private static final Log logger = LogFactory.getLog(HFCAIdentity.class);
    private static final Set<String> filtredUpdateAttrNames = new HashSet<String>(Arrays.asList("hf.EnrollmentID", "hf.Type", "hf.Affiliation"));

    HFCAIdentity(String enrollmentID, HFCAClient client) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(enrollmentID)) {
            throw new InvalidArgumentException("EnrollmentID cannot be null or empty");
        }
        if (client.getCryptoSuite() == null) {
            throw new InvalidArgumentException("Client's crypto primitives not set");
        }
        this.enrollmentID = enrollmentID;
        this.client = client;
    }

    HFCAIdentity(JsonObject result) {
        this.enrollmentID = result.getString("id");
        this.getHFCAIdentity(result);
    }

    public String getEnrollmentId() {
        return this.enrollmentID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Integer getMaxEnrollments() {
        return this.maxEnrollments;
    }

    public void setMaxEnrollments(Integer maxEnrollments) {
        this.maxEnrollments = maxEnrollments;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public void setAffiliation(HFCAAffiliation affiliation) {
        this.affiliation = affiliation.getName();
    }

    public Collection<Attribute> getAttributes() {
        return this.attrs;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        this.attrs = attributes;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int read(User registrar) throws IdentityException, InvalidArgumentException {
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String readIdURL = "";
        try {
            readIdURL = "/api/v1/identities/" + this.enrollmentID;
            logger.debug((Object)String.format("identity  url: %s, registrar: %s", readIdURL, registrar.getName()));
            JsonObject result = this.client.httpGet(readIdURL, registrar);
            this.statusCode = result.getInt("statusCode");
            if (this.statusCode < 400) {
                this.type = result.getString("type");
                this.maxEnrollments = result.getInt("max_enrollments");
                this.affiliation = result.getString("affiliation");
                JsonArray attributes = result.getJsonArray("attrs");
                ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                if (attributes != null && !attributes.isEmpty()) {
                    for (int i = 0; i < attributes.size(); ++i) {
                        JsonObject attribute = attributes.getJsonObject(i);
                        Attribute attr = new Attribute(attribute.getString("name"), attribute.getString("value"), attribute.getBoolean("ecert", false));
                        attrs.add(attr);
                    }
                }
                this.attrs = attrs;
                logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", readIdURL, registrar));
            }
            this.deleted = false;
            return this.statusCode;
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while getting user '%s' from url '%s': %s", e.getStatusCode(), this.getEnrollmentId(), readIdURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
        catch (Exception e) {
            String msg = String.format("Error while getting user '%s' from url '%s': %s", this.enrollmentID, readIdURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
    }

    public int create(User registrar) throws IdentityException, InvalidArgumentException {
        if (this.deleted) {
            throw new IdentityException("Identity has been deleted");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String createURL = "";
        try {
            createURL = this.client.getURL(HFCA_IDENTITY);
            logger.debug((Object)String.format("identity  url: %s, registrar: %s", createURL, registrar.getName()));
            String body = this.client.toJson(this.idToJsonObject());
            JsonObject result = this.client.httpPost(createURL, body, registrar);
            this.statusCode = result.getInt("statusCode");
            if (this.statusCode < 400) {
                this.getHFCAIdentity(result);
                logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", createURL, registrar));
            }
            this.deleted = false;
            return this.statusCode;
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while creating user '%s' from url '%s': %s", e.getStatusCode(), this.getEnrollmentId(), createURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
        catch (Exception e) {
            String msg = String.format("Error while creating user '%s' from url '%s':  %s", this.getEnrollmentId(), createURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
    }

    public int update(User registrar) throws IdentityException, InvalidArgumentException {
        if (this.deleted) {
            throw new IdentityException("Identity has been deleted");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String updateURL = "";
        try {
            updateURL = this.client.getURL("/api/v1/identities/" + this.getEnrollmentId());
            logger.debug((Object)String.format("identity  url: %s, registrar: %s", updateURL, registrar.getName()));
            String body = this.client.toJson(this.idToJsonObject(filtredUpdateAttrNames));
            JsonObject result = this.client.httpPut(updateURL, body, registrar);
            this.statusCode = result.getInt("statusCode");
            if (this.statusCode < 400) {
                this.getHFCAIdentity(result);
                logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", updateURL, registrar));
            }
            return this.statusCode;
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while updating user '%s' from url '%s': %s", e.getStatusCode(), this.getEnrollmentId(), updateURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
        catch (Exception e) {
            String msg = String.format("Error while updating user '%s' from url '%s':  %s", this.getEnrollmentId(), updateURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
    }

    public int delete(User registrar) throws IdentityException, InvalidArgumentException {
        if (this.deleted) {
            throw new IdentityException("Identity has been deleted");
        }
        if (registrar == null) {
            throw new InvalidArgumentException("Registrar should be a valid member");
        }
        String deleteURL = "";
        try {
            deleteURL = this.client.getURL("/api/v1/identities/" + this.getEnrollmentId());
            logger.debug((Object)String.format("identity  url: %s, registrar: %s", deleteURL, registrar.getName()));
            JsonObject result = this.client.httpDelete(deleteURL, registrar);
            this.statusCode = result.getInt("statusCode");
            if (this.statusCode < 400) {
                this.getHFCAIdentity(result);
                logger.debug((Object)String.format("identity  url: %s, registrar: %s done.", deleteURL, registrar));
            }
            this.deleted = true;
            return this.statusCode;
        }
        catch (HTTPException e) {
            String msg = String.format("[Code: %d] - Error while deleting user '%s' from url '%s': %s", e.getStatusCode(), this.getEnrollmentId(), deleteURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
        catch (Exception e) {
            String msg = String.format("Error while deleting user '%s' from url '%s':  %s", this.getEnrollmentId(), deleteURL, e.getMessage());
            IdentityException identityException = new IdentityException(msg, e);
            logger.error((Object)msg);
            throw identityException;
        }
    }

    private void getHFCAIdentity(JsonObject result) {
        this.type = result.getString("type");
        if (result.containsKey((Object)"secret")) {
            this.secret = result.getString("secret");
        }
        this.maxEnrollments = result.getInt("max_enrollments");
        this.affiliation = result.getString("affiliation");
        JsonArray attributes = result.getJsonArray("attrs");
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (attributes != null && !attributes.isEmpty()) {
            for (int i = 0; i < attributes.size(); ++i) {
                JsonObject attribute = attributes.getJsonObject(i);
                Attribute attr = new Attribute(attribute.getString("name"), attribute.getString("value"), attribute.getBoolean("ecert", false));
                attrs.add(attr);
            }
        }
        this.attrs = attrs;
    }

    private JsonObject idToJsonObject() {
        return this.idToJsonObject(Collections.emptySet());
    }

    private JsonObject idToJsonObject(Set<String> filteredAttrs) {
        JsonObjectBuilder ob = Json.createObjectBuilder();
        ob.add("id", this.enrollmentID);
        ob.add("type", this.type);
        if (null != this.maxEnrollments) {
            ob.add("max_enrollments", this.maxEnrollments.intValue());
        }
        if (this.affiliation != null) {
            ob.add("affiliation", this.affiliation);
        }
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (Attribute attr : this.attrs) {
            if (filteredAttrs.contains(attr.getName())) continue;
            ab.add((JsonValue)attr.toJsonObject());
        }
        ob.add("attrs", (JsonValue)ab.build());
        if (this.secret != null) {
            ob.add("secret", this.secret);
        }
        if (this.client.getCAName() != null) {
            ob.add("caname", this.client.getCAName());
        }
        return ob.build();
    }
}

