/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.hyperledger.fabric_ca.sdk.HFCACredential;
import org.hyperledger.fabric_ca.sdk.exception.HFCACertificateException;

public class HFCAX509Certificate
extends HFCACredential {
    private String pem;
    private X509Certificate x509Cert;
    private BigInteger serial;
    private AuthorityKeyIdentifier aki;

    HFCAX509Certificate(String pem) throws CertificateException, HFCACertificateException {
        this.pem = pem;
        this.x509Cert = this.getX509Certificate();
        this.serial = this.getSerial();
        this.aki = this.getAKI();
    }

    public String getPEM() {
        return this.pem;
    }

    public X509Certificate getX509() {
        return this.x509Cert;
    }

    private X509Certificate getX509Certificate() throws CertificateException, HFCACertificateException {
        if (this.pem == null) {
            throw new HFCACertificateException("Certificate PEM is null");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.pem.getBytes()));
    }

    private BigInteger getSerial() throws HFCACertificateException {
        if (this.x509Cert == null) {
            throw new HFCACertificateException("Certificate is null");
        }
        return this.x509Cert.getSerialNumber();
    }

    private AuthorityKeyIdentifier getAKI() throws HFCACertificateException {
        if (this.x509Cert == null) {
            throw new HFCACertificateException("Certificate is null");
        }
        byte[] fullExtValue = this.x509Cert.getExtensionValue(Extension.authorityKeyIdentifier.getId());
        byte[] extValue = ASN1OctetString.getInstance((Object)fullExtValue).getOctets();
        return AuthorityKeyIdentifier.getInstance((Object)extValue);
    }
}

