/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.hyperledger.fabric_ca.sdk.Attribute;

public class RegistrationRequest {
    private String enrollmentID;
    private String type = "client";
    private String secret;
    private Integer maxEnrollments = null;
    private String affiliation;
    private Collection<Attribute> attrs = new ArrayList<Attribute>();
    private String caName;

    public RegistrationRequest(String id) throws Exception {
        if (id == null) {
            throw new Exception("id may not be null");
        }
        this.enrollmentID = id;
    }

    public RegistrationRequest(String id, String affiliation) throws Exception {
        if (id == null) {
            throw new Exception("id may not be null");
        }
        if (affiliation == null) {
            throw new Exception("affiliation may not be null");
        }
        this.enrollmentID = id;
        this.affiliation = affiliation;
    }

    public String getEnrollmentID() {
        return this.enrollmentID;
    }

    public void setEnrollmentID(String enrollmentID) {
        this.enrollmentID = enrollmentID;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Integer getMaxEnrollments() {
        return this.maxEnrollments;
    }

    public void setMaxEnrollments(int maxEnrollments) {
        this.maxEnrollments = maxEnrollments;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public Collection<Attribute> getAttributes() {
        return this.attrs;
    }

    public void addAttribute(Attribute attr) {
        this.attrs.add(attr);
    }

    void setCAName(String caName) {
        this.caName = caName;
    }

    String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(stringWriter));
        jsonWriter.writeObject(this.toJsonObject());
        jsonWriter.close();
        return stringWriter.toString();
    }

    JsonObject toJsonObject() {
        JsonObjectBuilder ob = Json.createObjectBuilder();
        ob.add("id", this.enrollmentID);
        ob.add("type", this.type);
        if (this.secret != null) {
            ob.add("secret", this.secret);
        }
        if (null != this.maxEnrollments) {
            ob.add("max_enrollments", this.maxEnrollments.intValue());
        }
        if (this.affiliation != null) {
            ob.add("affiliation", this.affiliation);
        }
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (Attribute attr : this.attrs) {
            ab.add((JsonValue)attr.toJsonObject());
        }
        if (this.caName != null) {
            ob.add("caname", this.caName);
        }
        ob.add("attrs", (JsonValue)ab.build());
        return ob.build();
    }
}

