/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.hyperledger.fabric.sdk.helper.Utils;

class RevocationRequest {
    private final String caName;
    private String enrollmentID;
    private String serial;
    private String aki;
    private String reason;
    private Boolean genCRL;

    RevocationRequest(String caName, String id, String serial, String aki, String reason) throws Exception {
        if (Utils.isNullOrEmpty(id) && (Utils.isNullOrEmpty(serial) || Utils.isNullOrEmpty(aki))) {
            throw new Exception("Enrollment ID is empty, thus both aki and serial must have non-empty values");
        }
        this.enrollmentID = id;
        this.serial = serial;
        this.aki = aki;
        this.reason = reason;
        this.caName = caName;
    }

    RevocationRequest(String caName, String id, String serial, String aki, String reason, Boolean genCRL) throws Exception {
        this(caName, id, serial, aki, reason);
        this.genCRL = genCRL;
    }

    String getUser() {
        return this.enrollmentID;
    }

    void setUser(String user) {
        this.enrollmentID = user;
    }

    String getSerial() {
        return this.serial;
    }

    void setSerial(String serial) {
        this.serial = serial;
    }

    String getAki() {
        return this.aki;
    }

    void setAki(String aki) {
        this.aki = aki;
    }

    String getReason() {
        return this.reason;
    }

    void setReason(String reason) {
        this.reason = reason;
    }

    Boolean getGenCRL() {
        return this.genCRL;
    }

    void setGenCRL(Boolean genCRL) {
        this.genCRL = genCRL;
    }

    String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)new PrintWriter(stringWriter));
        jsonWriter.writeObject(this.toJsonObject());
        jsonWriter.close();
        return stringWriter.toString();
    }

    private JsonObject toJsonObject() {
        JsonObjectBuilder factory = Json.createObjectBuilder();
        if (this.enrollmentID != null) {
            factory.add("id", this.enrollmentID);
        } else {
            factory.add("serial", this.serial);
            factory.add("aki", this.aki);
        }
        if (null != this.reason) {
            factory.add("reason", this.reason);
        }
        if (this.caName != null) {
            factory.add("caname", this.caName);
        }
        if (this.genCRL != null) {
            factory.add("gencrl", this.genCRL.booleanValue());
        }
        return factory.build();
    }
}

