/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric_ca.sdk.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Config {
    private static final Log logger = LogFactory.getLog(Config.class);
    private static final String BASE_PROP = "org.hyperledger.fabric_ca.sdk.";
    private static final String DEFAULT_CONFIG = "config.properties";
    public static final String ORG_HYPERLEDGER_FABRIC_SDK_CONFIGURATION = "org.hyperledger.fabric_ca.sdk.configuration";
    public static final String SECURITY_LEVEL = "org.hyperledger.fabric_ca.sdk.security_level";
    public static final String HASH_ALGORITHM = "org.hyperledger.fabric_ca.sdk.hash_algorithm";
    public static final String CACERTS = "cacerts";
    public static final String PROPOSAL_WAIT_TIME = "org.hyperledger.fabric_ca.sdk.proposal.wait.time";
    public static final String ASYMMETRIC_KEY_TYPE = "org.hyperledger.fabric_ca.sdk.crypto.asymmetric_key_type";
    public static final String KEY_AGREEMENT_ALGORITHM = "org.hyperledger.fabric_ca.sdk.crypto.key_agreement_algorithm";
    public static final String SYMMETRIC_KEY_TYPE = "org.hyperledger.fabric_ca.sdk.crypto.symmetric_key_type";
    public static final String SYMMETRIC_KEY_BYTE_COUNT = "org.hyperledger.fabric_ca.sdk.crypto.symmetric_key_byte_count";
    public static final String SYMMETRIC_ALGORITHM = "org.hyperledger.fabric_ca.sdk.crypto.symmetric_algorithm";
    public static final String MAC_KEY_BYTE_COUNT = "org.hyperledger.fabric_ca.sdk.crypto.mac_key_byte_count";
    public static final String CERTIFICATE_FORMAT = "org.hyperledger.fabric_ca.sdk.crypto.certificate_format";
    public static final String SIGNATURE_ALGORITHM = "org.hyperledger.fabric_ca.sdk.crypto.default_signature_algorithm";
    public static final String MAX_LOG_STRING_LENGTH = "org.hyperledger.fabric_ca.sdk.log.stringlengthmax";
    public static final String LOGGERLEVEL = "org.hyperledger.fabric_ca.sdk.loglevel";
    public static final String CONNECTION_REQUEST_TIMEOUT = "org.hyperledger.fabric_ca.sdk.connection.connection_request_timeout";
    public static final String CONNECT_TIMEOUT = "org.hyperledger.fabric_ca.sdk.connection.connect_timeout";
    public static final String SOCKET_TIMEOUT = "org.hyperledger.fabric_ca.sdk.connection.socket_timeout";
    private static Config config;
    private static final Properties sdkProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config() {
        try {
            File loadFile = new File(System.getProperty(ORG_HYPERLEDGER_FABRIC_SDK_CONFIGURATION, DEFAULT_CONFIG)).getAbsoluteFile();
            logger.debug((Object)String.format("Loading configuration from %s and it is present: %b", loadFile.toString(), loadFile.exists()));
            FileInputStream configProps = new FileInputStream(loadFile);
            sdkProperties.load(configProps);
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Failed to load any configuration from: %s. Using toolkit defaults", DEFAULT_CONFIG));
        }
        finally {
            Config.defaultProperty(ASYMMETRIC_KEY_TYPE, "EC");
            Config.defaultProperty(KEY_AGREEMENT_ALGORITHM, "ECDH");
            Config.defaultProperty(SYMMETRIC_KEY_TYPE, "AES");
            Config.defaultProperty(SYMMETRIC_KEY_BYTE_COUNT, "32");
            Config.defaultProperty(SYMMETRIC_ALGORITHM, "AES/CFB/NoPadding");
            Config.defaultProperty(MAC_KEY_BYTE_COUNT, "32");
            Config.defaultProperty(CERTIFICATE_FORMAT, "X.509");
            Config.defaultProperty(SIGNATURE_ALGORITHM, "SHA256withECDSA");
            Config.defaultProperty(SECURITY_LEVEL, "256");
            Config.defaultProperty(HASH_ALGORITHM, "SHA2");
            Config.defaultProperty(CONNECTION_REQUEST_TIMEOUT, "-1");
            Config.defaultProperty(CONNECT_TIMEOUT, "-1");
            Config.defaultProperty(SOCKET_TIMEOUT, "-1");
            Config.defaultProperty(CACERTS, "/genesisblock/peercacert.pem");
            Config.defaultProperty(PROPOSAL_WAIT_TIME, "12000");
            Config.defaultProperty(MAX_LOG_STRING_LENGTH, "64");
            Config.defaultProperty(LOGGERLEVEL, null);
            String inLogLevel = sdkProperties.getProperty(LOGGERLEVEL);
            if (null != inLogLevel) {
                Level setTo = null;
                switch (inLogLevel) {
                    case "TRACE": {
                        setTo = Level.TRACE;
                        break;
                    }
                    case "DEBUG": {
                        setTo = Level.DEBUG;
                        break;
                    }
                    case "INFO": {
                        setTo = Level.INFO;
                        break;
                    }
                    case "WARN": {
                        setTo = Level.WARN;
                        break;
                    }
                    case "ERROR": {
                        setTo = Level.ERROR;
                        break;
                    }
                    default: {
                        setTo = Level.INFO;
                    }
                }
                if (null != setTo) {
                    Logger.getLogger((String)"org.hyperledger.fabric_ca").setLevel(setTo);
                }
            }
        }
    }

    public static Config getConfig() {
        if (null == config) {
            config = new Config();
        }
        return config;
    }

    private String getProperty(String property) {
        String ret = sdkProperties.getProperty(property);
        if (null == ret) {
            logger.warn((Object)String.format("No configuration value found for '%s'", property));
        }
        return ret;
    }

    private static void defaultProperty(String key, String value) {
        String ret = System.getProperty(key);
        if (ret != null) {
            sdkProperties.put(key, ret);
        } else {
            String envKey = key.toUpperCase().replaceAll("\\.", "_");
            ret = System.getenv(envKey);
            if (null != ret) {
                sdkProperties.put(key, ret);
            } else if (null == sdkProperties.getProperty(key) && value != null) {
                sdkProperties.put(key, value);
            }
        }
    }

    public int getSecurityLevel() {
        return Integer.parseInt(this.getProperty(SECURITY_LEVEL));
    }

    public String getHashAlgorithm() {
        return this.getProperty(HASH_ALGORITHM);
    }

    public String[] getPeerCACerts() {
        return this.getProperty(CACERTS).split("'");
    }

    public long getProposalWaitTime() {
        return Long.parseLong(this.getProperty(PROPOSAL_WAIT_TIME));
    }

    public String getAsymmetricKeyType() {
        return this.getProperty(ASYMMETRIC_KEY_TYPE);
    }

    public String getKeyAgreementAlgorithm() {
        return this.getProperty(KEY_AGREEMENT_ALGORITHM);
    }

    public String getSymmetricKeyType() {
        return this.getProperty(SYMMETRIC_KEY_TYPE);
    }

    public int getSymmetricKeyByteCount() {
        return Integer.parseInt(this.getProperty(SYMMETRIC_KEY_BYTE_COUNT));
    }

    public String getSymmetricAlgorithm() {
        return this.getProperty(SYMMETRIC_ALGORITHM);
    }

    public int getMACKeyByteCount() {
        return Integer.parseInt(this.getProperty(MAC_KEY_BYTE_COUNT));
    }

    public String getCertificateFormat() {
        return this.getProperty(CERTIFICATE_FORMAT);
    }

    public String getSignatureAlgorithm() {
        return this.getProperty(SIGNATURE_ALGORITHM);
    }

    public int maxLogStringLength() {
        return Integer.parseInt(this.getProperty(MAX_LOG_STRING_LENGTH));
    }

    public int getConnectionRequestTimeout() {
        return Integer.parseInt(this.getProperty(CONNECTION_REQUEST_TIMEOUT));
    }

    public int getConnectTimeout() {
        return Integer.parseInt(this.getProperty(CONNECT_TIMEOUT));
    }

    public int getSocketTimeout() {
        return Integer.parseInt(this.getProperty(SOCKET_TIMEOUT));
    }

    static {
        sdkProperties = new Properties();
    }
}

