package com.test.fabricdemo;

import org.hyperledger.fabric.gateway.*;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.sdk.*;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;

/**
 * @author lps
 * @title: demo1
 * @projectName fabricdemo
 * @description: fabric2.0 java SDK
 * @date 2020/2/2218:10
 */
public class eccDemo {

    private static final Path NETWORK_CONFIG_PATH = Paths.get("src/main/resources/crypto-config/eccUser/config.yaml");
    private static final Path credentialPath = Paths.get("src/main/resources/crypto-config/eccUser");
    
    public static void main(String[] args) {

        try {
            Wallet wallet = Wallets.newInMemoryWallet();
            Path certificatePath = credentialPath.resolve(Paths.get("user_sign.crt"));
            X509Certificate certificate = readX509Certificate(certificatePath);

            Path privateKeyPath = credentialPath.resolve(Paths.get("user_ecc_sign.key"));
            PrivateKey privateKey = getPrivateKey(privateKeyPath);

            wallet.put("eccUser", Identities.newX509Identity("org-251005746.fabric-5x6wdaow3q", certificate, privateKey));

            GatewayImpl.Builder builder = (GatewayImpl.Builder) Gateway.createBuilder();

            builder.identity(wallet, "eccUser").networkConfig(NETWORK_CONFIG_PATH);
            Gateway gateway = builder.connect();
            Network network = gateway.getNetwork("channel-9xjcb2");
            Contract contract = network.getContract("gotest");

            byte[] invokeResult = contract.createTransaction("Set")
                    .setEndorsingPeers(network.getChannel().getPeers(EnumSet.of(Peer.PeerRole.ENDORSING_PEER)))
                    .submit("A", "20");
            System.out.println(new String(invokeResult, StandardCharsets.UTF_8));
            byte[] queryAResultAfter = contract.evaluateTransaction("Get","A");
            System.out.println("交易后："+new String(queryAResultAfter, StandardCharsets.UTF_8));
            Thread.sleep(500);

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static X509Certificate readX509Certificate(final Path certificatePath) throws IOException, CertificateException {
        try (Reader certificateReader = Files.newBufferedReader(certificatePath, StandardCharsets.UTF_8)) {
            return Identities.readX509Certificate(certificateReader);
        }
    }

    public static PrivateKey getPrivateKey(final Path privateKeyPath) throws IOException, InvalidKeyException {
        try (Reader privateKeyReader = Files.newBufferedReader(privateKeyPath, StandardCharsets.UTF_8)) {
            return Identities.readPrivateKey(privateKeyReader);
        }
    }
}

